/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.mosaic;

import java.math.BigInteger;
import org.apache.commons.lang3.Validate;

public class MosaicProperties {
    private final boolean supplyMutable;
    private final boolean transferable;
    private final boolean levyMutable;
    private final int divisibility;
    private final BigInteger duration;

    public MosaicProperties(boolean supplyMutable, boolean transferable, boolean levyMutable, int divisibility, BigInteger duration) {
        Validate.notNull((Object)duration, (String)"Duration cannot be null", (Object[])new Object[0]);
        this.supplyMutable = supplyMutable;
        this.transferable = transferable;
        this.levyMutable = levyMutable;
        this.divisibility = divisibility;
        this.duration = duration;
    }

    public boolean isSupplyMutable() {
        return this.supplyMutable;
    }

    public boolean isTransferable() {
        return this.transferable;
    }

    public boolean isLevyMutable() {
        return this.levyMutable;
    }

    public BigInteger getDuration() {
        return this.duration;
    }

    public int getDivisibility() {
        return this.divisibility;
    }

    public static class Builder {
        private boolean supplyMutable;
        private boolean transferable;
        private boolean levyMutable;
        private int divisibility;
        private BigInteger duration;

        public Builder supplyMutable(boolean supplyMutable) {
            this.supplyMutable = supplyMutable;
            return this;
        }

        public Builder transferable(boolean transferable) {
            this.transferable = transferable;
            return this;
        }

        public Builder levyMutable(boolean levyMutable) {
            this.levyMutable = levyMutable;
            return this;
        }

        public Builder divisibility(int divisibility) {
            this.divisibility = divisibility;
            return this;
        }

        public Builder duration(BigInteger duration) {
            this.duration = duration;
            return this;
        }

        public MosaicProperties build() {
            return new MosaicProperties(this.supplyMutable, this.transferable, this.levyMutable, this.divisibility, this.duration);
        }
    }
}

