/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.mosaic;

import io.nem.sdk.model.mosaic.IllegalIdentifierException;
import io.nem.sdk.model.transaction.IdGenerator;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public class MosaicId {
    private final BigInteger id;
    private final Optional<String> fullName;

    public MosaicId(String id) {
        if (id.isEmpty()) {
            throw new IllegalIdentifierException(id + " is not valid");
        }
        if (!id.contains(":")) {
            throw new IllegalIdentifierException(id + " is not valid");
        }
        String[] parts = id.split(":");
        if (parts.length != 2) {
            throw new IllegalIdentifierException(id + " is not valid");
        }
        String namespaceName = parts[0];
        String mosaicName = parts[1];
        this.id = IdGenerator.generateMosaicId(namespaceName, mosaicName);
        this.fullName = Optional.of(id);
    }

    public MosaicId(BigInteger id) {
        this.id = id;
        this.fullName = Optional.empty();
    }

    public BigInteger getId() {
        return this.id;
    }

    public Optional<String> getFullName() {
        return this.fullName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MosaicId)) {
            return false;
        }
        MosaicId mosaicId1 = (MosaicId)o;
        return Objects.equals(this.id, mosaicId1.id);
    }
}

