/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.blockchain;

import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import java.math.BigInteger;
import java.util.Optional;

public class BlockInfo {
    private final String hash;
    private final String generationHash;
    private final Optional<BigInteger> totalFee;
    private final Optional<Integer> numTransactions;
    private final String signature;
    private final PublicAccount signer;
    private final NetworkType networkType;
    private final Integer version;
    private final int type;
    private final BigInteger height;
    private final BigInteger timestamp;
    private final BigInteger difficulty;
    private final String previousBlockHash;
    private final String blockTransactionsHash;

    public BlockInfo(String hash, String generationHash, Optional<BigInteger> totalFee, Optional<Integer> numTransactions, String signature, PublicAccount signer, NetworkType networkType, Integer version, int type, BigInteger height, BigInteger timestamp, BigInteger difficulty, String previousBlockHash, String blockTransactionsHash) {
        this.hash = hash;
        this.generationHash = generationHash;
        this.totalFee = totalFee;
        this.numTransactions = numTransactions;
        this.signature = signature;
        this.signer = signer;
        this.networkType = networkType;
        this.version = version;
        this.type = type;
        this.height = height;
        this.timestamp = timestamp;
        this.difficulty = difficulty;
        this.previousBlockHash = previousBlockHash;
        this.blockTransactionsHash = blockTransactionsHash;
    }

    public String getHash() {
        return this.hash;
    }

    public String getGenerationHash() {
        return this.generationHash;
    }

    public Optional<BigInteger> getTotalFee() {
        return this.totalFee;
    }

    public Optional<Integer> getNumTransactions() {
        return this.numTransactions;
    }

    public String getSignature() {
        return this.signature;
    }

    public PublicAccount getSigner() {
        return this.signer;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public Integer getVersion() {
        return this.version;
    }

    public int getType() {
        return this.type;
    }

    public BigInteger getHeight() {
        return this.height;
    }

    public BigInteger getTimestamp() {
        return this.timestamp;
    }

    public BigInteger getDifficulty() {
        return this.difficulty;
    }

    public String getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    public String getBlockTransactionsHash() {
        return this.blockTransactionsHash;
    }

    public String toString() {
        return "BlockInfo{hash='" + this.hash + '\'' + ", generationHash='" + this.generationHash + '\'' + ", totalFee=" + this.totalFee + ", numTransactions=" + this.numTransactions + ", signature='" + this.signature + '\'' + ", signer=" + this.signer + ", networkType=" + (Object)((Object)this.networkType) + ", version=" + this.version + ", type=" + this.type + ", height=" + this.height + ", timestamp=" + this.timestamp + ", difficulty=" + this.difficulty + ", previousBlockHash='" + this.previousBlockHash + '\'' + ", blockTransactionsHash='" + this.blockTransactionsHash + '\'' + '}';
    }
}

