/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.account;

import io.nem.sdk.model.account.PublicAccount;
import java.util.List;

public class MultisigAccountInfo {
    private final PublicAccount account;
    private final int minApproval;
    private final int minRemoval;
    private final List<PublicAccount> cosignatories;
    private final List<PublicAccount> multisigAccounts;

    public MultisigAccountInfo(PublicAccount account, int minApproval, int minRemoval, List<PublicAccount> cosignatories, List<PublicAccount> multisigAccounts) {
        this.account = account;
        this.minApproval = minApproval;
        this.minRemoval = minRemoval;
        this.cosignatories = cosignatories;
        this.multisigAccounts = multisigAccounts;
    }

    public PublicAccount getAccount() {
        return this.account;
    }

    public int getMinApproval() {
        return this.minApproval;
    }

    public int getMinRemoval() {
        return this.minRemoval;
    }

    public List<PublicAccount> getCosignatories() {
        return this.cosignatories;
    }

    public List<PublicAccount> getMultisigAccounts() {
        return this.multisigAccounts;
    }

    public boolean hasCosigner(PublicAccount account) {
        return this.cosignatories.contains(account);
    }

    public boolean isCosignerOfMultisigAccount(PublicAccount account) {
        return this.multisigAccounts.contains(account);
    }

    public boolean isMultisig() {
        return this.minApproval != 0 && this.minRemoval != 0;
    }
}

