/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.account;

import io.nem.core.crypto.Hashes;
import io.nem.core.utils.ArrayUtils;
import io.nem.core.utils.Base32Encoder;
import io.nem.sdk.model.blockchain.NetworkType;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Hex;

public class Address {
    private static final int NUM_CHECKSUM_BYTES = 4;
    private final String address;
    private final NetworkType networkType;

    public Address(String address, NetworkType networkType) {
        this.address = Objects.requireNonNull(address, "address must not be null").replace("-", "").trim().toUpperCase();
        this.networkType = Objects.requireNonNull(networkType, "networkType must not be null");
        char addressNetwork = this.address.charAt(0);
        if (networkType.equals((Object)NetworkType.MAIN_NET) && addressNetwork != 'N') {
            throw new IllegalArgumentException("MAIN_NET Address must start with N");
        }
        if (networkType.equals((Object)NetworkType.TEST_NET) && addressNetwork != 'T') {
            throw new IllegalArgumentException("TEST_NET Address must start with T");
        }
        if (networkType.equals((Object)NetworkType.MIJIN) && addressNetwork != 'M') {
            throw new IllegalArgumentException("MIJIN Address must start with M");
        }
        if (networkType.equals((Object)NetworkType.MIJIN_TEST) && addressNetwork != 'S') {
            throw new IllegalArgumentException("MIJIN_TEST Address must start with S");
        }
    }

    public static Address createFromRawAddress(String rawAddress) {
        char addressNetwork = rawAddress.charAt(0);
        if (addressNetwork == 'N') {
            return new Address(rawAddress, NetworkType.MAIN_NET);
        }
        if (addressNetwork == 'T') {
            return new Address(rawAddress, NetworkType.TEST_NET);
        }
        if (addressNetwork == 'M') {
            return new Address(rawAddress, NetworkType.MIJIN);
        }
        if (addressNetwork == 'S') {
            return new Address(rawAddress, NetworkType.MIJIN_TEST);
        }
        throw new IllegalArgumentException("Address is invalid");
    }

    public static Address createFromEncoded(String encodedAddress) {
        try {
            return Address.createFromRawAddress(new String(new Base32().encode(Hex.decodeHex((String)encodedAddress))));
        }
        catch (DecoderException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static Address createFromPublicKey(String publicKey, NetworkType networkType) {
        return new Address(Address.generateEncoded((byte)networkType.getValue(), publicKey), networkType);
    }

    private static String generateEncoded(byte version, String publicKey) {
        byte[] publicKeyBytes;
        try {
            publicKeyBytes = Hex.decodeHex((String)publicKey);
        }
        catch (DecoderException e) {
            throw new RuntimeException("public key is not valid");
        }
        byte[] sha3PublicKeyHash = Hashes.sha3_256(new byte[][]{publicKeyBytes});
        byte[] ripemd160StepOneHash = Hashes.ripemd160(new byte[][]{sha3PublicKeyHash});
        byte[] versionPrefixedRipemd160Hash = ArrayUtils.concat({version}, ripemd160StepOneHash);
        byte[] stepThreeChecksum = Address.generateChecksum(versionPrefixedRipemd160Hash);
        byte[] concatStepThreeAndStepSix = ArrayUtils.concat(versionPrefixedRipemd160Hash, stepThreeChecksum);
        return Base32Encoder.getString(concatStepThreeAndStepSix);
    }

    private static byte[] generateChecksum(byte[] input) {
        byte[] sha3StepThreeHash = Hashes.sha3_256(new byte[][]{input});
        return Arrays.copyOfRange(sha3StepThreeHash, 0, 4);
    }

    public String plain() {
        return this.address;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public String pretty() {
        return this.address.substring(0, 6) + "-" + this.address.substring(6, 12) + "-" + this.address.substring(12, 18) + "-" + this.address.substring(18, 24) + "-" + this.address.substring(24, 30) + "-" + this.address.substring(30, 36) + "-" + this.address.substring(36, 40);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address address1 = (Address)o;
        return Objects.equals(this.address, address1.address) && this.networkType == address1.networkType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.networkType});
    }
}

