/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure;

import io.nem.sdk.infrastructure.TransactionMapping;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.namespace.NamespaceId;
import io.nem.sdk.model.namespace.NamespaceType;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.RegisterNamespaceTransaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.vertx.core.json.JsonObject;
import java.util.Optional;

class NamespaceCreationTransactionMapping
extends TransactionMapping {
    NamespaceCreationTransactionMapping() {
    }

    @Override
    public RegisterNamespaceTransaction apply(JsonObject input) {
        TransactionInfo transactionInfo = this.createTransactionInfo(input.getJsonObject("meta"));
        JsonObject transaction = input.getJsonObject("transaction");
        Deadline deadline = new Deadline(this.extractBigInteger(transaction.getJsonArray("deadline")));
        NamespaceType namespaceType = NamespaceType.rawValueOf(transaction.getInteger("namespaceType"));
        return new RegisterNamespaceTransaction(this.extractNetworkType(transaction.getInteger("version")), this.extractTransactionVersion(transaction.getInteger("version")), deadline, this.extractBigInteger(transaction.getJsonArray("fee")), transaction.getString("name"), new NamespaceId(this.extractBigInteger(transaction.getJsonArray("namespaceId"))), namespaceType, namespaceType == NamespaceType.RootNamespace ? Optional.of(this.extractBigInteger(transaction.getJsonArray("duration"))) : Optional.empty(), namespaceType == NamespaceType.SubNamespace ? Optional.of(new NamespaceId(this.extractBigInteger(transaction.getJsonArray("parentId")))) : Optional.empty(), transaction.getString("signature"), new PublicAccount(transaction.getString("signer"), this.extractNetworkType(transaction.getInteger("version"))), transactionInfo);
    }
}

