/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure;

import io.nem.sdk.infrastructure.TransactionMapping;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.mosaic.MosaicProperties;
import io.nem.sdk.model.namespace.NamespaceId;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.MosaicDefinitionTransaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.math.BigInteger;

class MosaicCreationTransactionMapping
extends TransactionMapping {
    MosaicCreationTransactionMapping() {
    }

    @Override
    public MosaicDefinitionTransaction apply(JsonObject input) {
        TransactionInfo transactionInfo = this.createTransactionInfo(input.getJsonObject("meta"));
        JsonObject transaction = input.getJsonObject("transaction");
        Deadline deadline = new Deadline(this.extractBigInteger(transaction.getJsonArray("deadline")));
        JsonArray mosaicProperties = transaction.getJsonArray("properties");
        String flags = "00" + Integer.toBinaryString(this.extractBigInteger(mosaicProperties.getJsonObject(0).getJsonArray("value")).intValue());
        String bitMapFlags = flags.substring(flags.length() - 3, flags.length());
        MosaicProperties properties = new MosaicProperties(bitMapFlags.charAt(2) == '1', bitMapFlags.charAt(1) == '1', bitMapFlags.charAt(0) == '1', this.extractBigInteger(mosaicProperties.getJsonObject(1).getJsonArray("value")).intValue(), mosaicProperties.size() == 3 ? this.extractBigInteger(mosaicProperties.getJsonObject(2).getJsonArray("value")) : BigInteger.valueOf(0L));
        return new MosaicDefinitionTransaction(this.extractNetworkType(transaction.getInteger("version")), this.extractTransactionVersion(transaction.getInteger("version")), deadline, this.extractBigInteger(transaction.getJsonArray("fee")), transaction.getString("name"), new NamespaceId(this.extractBigInteger(transaction.getJsonArray("parentId"))), new MosaicId(this.extractBigInteger(transaction.getJsonArray("mosaicId"))), properties, transaction.getString("signature"), new PublicAccount(transaction.getString("signer"), this.extractNetworkType(transaction.getInteger("version"))), transactionInfo);
    }
}

