/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.nem.sdk.infrastructure.NetworkHttp;
import io.nem.sdk.model.blockchain.NetworkType;
import io.reactivex.Observable;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.web.client.HttpResponse;
import io.vertx.reactivex.ext.web.client.WebClient;
import java.net.MalformedURLException;
import java.net.URL;

public class Http {
    protected final WebClient client;
    protected final URL url;
    protected final ObjectMapper objectMapper = new ObjectMapper();
    private NetworkHttp networkHttp;
    private NetworkType networkType;

    Http(String host, NetworkHttp networkHttp) throws MalformedURLException {
        this.url = new URL(host);
        Vertx vertx = Vertx.vertx();
        this.client = WebClient.create((Vertx)vertx);
        this.objectMapper.configure(DeserializationFeature.USE_LONG_FOR_INTS, true);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.networkHttp = networkHttp;
    }

    Http(String host) throws MalformedURLException {
        this(host, null);
    }

    Observable<NetworkType> getNetworkTypeObservable() {
        Observable networkTypeResolve = this.networkType == null ? this.networkHttp.getNetworkType().map(networkType -> {
            this.networkType = networkType;
            return networkType;
        }) : Observable.just((Object)((Object)this.networkType));
        return networkTypeResolve;
    }

    static JsonObject mapJsonObjectOrError(HttpResponse<JsonObject> response) {
        if (response.statusCode() < 200 || response.statusCode() > 299) {
            throw new RuntimeException(response.statusMessage());
        }
        return (JsonObject)response.body();
    }

    static JsonArray mapJsonArrayOrError(HttpResponse<JsonArray> response) {
        if (response.statusCode() < 200 || response.statusCode() > 299) {
            throw new RuntimeException(response.statusMessage());
        }
        return (JsonArray)response.body();
    }
}

