/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure;

import io.nem.sdk.infrastructure.TransactionMapping;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.AggregateTransaction;
import io.nem.sdk.model.transaction.AggregateTransactionCosignature;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.nem.sdk.model.transaction.TransactionType;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.stream.Collectors;

class AggregateTransactionMapping
extends TransactionMapping {
    AggregateTransactionMapping() {
    }

    @Override
    public AggregateTransaction apply(JsonObject input) {
        TransactionInfo transactionInfo = this.createTransactionInfo(input.getJsonObject("meta"));
        JsonObject transaction = input.getJsonObject("transaction");
        Deadline deadline = new Deadline(this.extractBigInteger(transaction.getJsonArray("deadline")));
        NetworkType networkType = this.extractNetworkType(transaction.getInteger("version"));
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        for (int i = 0; i < transaction.getJsonArray("transactions").getList().size(); ++i) {
            JsonObject innerTransaction = transaction.getJsonArray("transactions").getJsonObject(i);
            innerTransaction.getJsonObject("transaction").put("deadline", transaction.getJsonArray("deadline"));
            innerTransaction.getJsonObject("transaction").put("fee", transaction.getJsonArray("fee"));
            innerTransaction.getJsonObject("transaction").put("signature", transaction.getString("signature"));
            if (!innerTransaction.containsKey("meta")) {
                innerTransaction.put("meta", input.getJsonObject("meta"));
            }
            transactions.add(new TransactionMapping().apply(innerTransaction));
        }
        ArrayList<AggregateTransactionCosignature> cosignatures = new ArrayList();
        if (transaction.getJsonArray("cosignatures") != null) {
            cosignatures = transaction.getJsonArray("cosignatures").stream().map(item -> (JsonObject)item).map(aggregateCosignature -> new AggregateTransactionCosignature(aggregateCosignature.getString("signature"), new PublicAccount(aggregateCosignature.getString("signer"), networkType))).collect(Collectors.toList());
        }
        return new AggregateTransaction(networkType, TransactionType.rawValueOf(transaction.getInteger("type")), this.extractTransactionVersion(transaction.getInteger("version")), deadline, this.extractBigInteger(transaction.getJsonArray("fee")), transactions, cosignatures, transaction.getString("signature"), new PublicAccount(transaction.getString("signer"), networkType), transactionInfo);
    }
}

