/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure;

import com.google.gson.annotations.SerializedName;
import io.nem.sdk.infrastructure.MosaicDTO;
import io.nem.sdk.infrastructure.UInt64DTO;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Hex;

class AccountDTO {
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="addressHeight")
    private UInt64DTO addressHeight = null;
    @SerializedName(value="publicKey")
    private String publicKey = null;
    @SerializedName(value="publicKeyHeight")
    private UInt64DTO publicKeyHeight = null;
    @SerializedName(value="mosaics")
    private List<MosaicDTO> mosaics = new ArrayList<MosaicDTO>();
    @SerializedName(value="importance")
    private UInt64DTO importance = null;
    @SerializedName(value="importanceHeight")
    private UInt64DTO importanceHeight = null;

    AccountDTO() {
    }

    public AccountDTO address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public AccountDTO addressHeight(UInt64DTO addressHeight) {
        this.addressHeight = addressHeight;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public UInt64DTO getAddressHeight() {
        return this.addressHeight;
    }

    public void setAddressHeight(UInt64DTO addressHeight) {
        this.addressHeight = addressHeight;
    }

    public AccountDTO publicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public AccountDTO publicKeyHeight(UInt64DTO publicKeyHeight) {
        this.publicKeyHeight = publicKeyHeight;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public UInt64DTO getPublicKeyHeight() {
        return this.publicKeyHeight;
    }

    public void setPublicKeyHeight(UInt64DTO publicKeyHeight) {
        this.publicKeyHeight = publicKeyHeight;
    }

    public AccountDTO mosaics(List<MosaicDTO> mosaics) {
        this.mosaics = mosaics;
        return this;
    }

    public AccountDTO addMosaicsItem(MosaicDTO mosaicsItem) {
        this.mosaics.add(mosaicsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<MosaicDTO> getMosaics() {
        return this.mosaics;
    }

    public void setMosaics(List<MosaicDTO> mosaics) {
        this.mosaics = mosaics;
    }

    public AccountDTO importance(UInt64DTO importance) {
        this.importance = importance;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public UInt64DTO getImportance() {
        return this.importance;
    }

    public void setImportance(UInt64DTO importance) {
        this.importance = importance;
    }

    public AccountDTO importanceHeight(UInt64DTO importanceHeight) {
        this.importanceHeight = importanceHeight;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public UInt64DTO getImportanceHeight() {
        return this.importanceHeight;
    }

    public void setImportanceHeight(UInt64DTO importanceHeight) {
        this.importanceHeight = importanceHeight;
    }

    public String getAddressEncoded() throws DecoderException {
        return new String(new Base32().encode(Hex.decodeHex((String)this.address)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountDTO accountDTO = (AccountDTO)o;
        return Objects.equals(this.address, accountDTO.address) && Objects.equals(this.addressHeight, accountDTO.addressHeight) && Objects.equals(this.publicKey, accountDTO.publicKey) && Objects.equals(this.publicKeyHeight, accountDTO.publicKeyHeight) && Objects.equals(this.mosaics, accountDTO.mosaics) && Objects.equals(this.importance, accountDTO.importance) && Objects.equals(this.importanceHeight, accountDTO.importanceHeight);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.addressHeight, this.publicKey, this.publicKeyHeight, this.mosaics, this.importance, this.importanceHeight);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountDTO {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    addressHeight: ").append(this.toIndentedString(this.addressHeight)).append("\n");
        sb.append("    publicKey: ").append(this.toIndentedString(this.publicKey)).append("\n");
        sb.append("    publicKeyHeight: ").append(this.toIndentedString(this.publicKeyHeight)).append("\n");
        sb.append("    mosaics: ").append(this.toIndentedString(this.mosaics)).append("\n");
        sb.append("    importance: ").append(this.toIndentedString(this.importance)).append("\n");
        sb.append("    importanceHeight: ").append(this.toIndentedString(this.importanceHeight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

