/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.utils;

import io.nem.core.utils.StringUtils;
import java.util.Collection;
import java.util.regex.Pattern;

public class MustBe {
    public static void notNull(Object obj, String name) {
        if (null == obj) {
            String message = String.format("%s cannot be null", name);
            throw new IllegalArgumentException(message);
        }
    }

    public static void notWhitespace(String str, String name, int maxLength) {
        if (StringUtils.isNullOrWhitespace(str) || str.length() > maxLength) {
            String message = String.format("%s cannot be null, empty, or whitespace, or have length greater than %d", name, maxLength);
            throw new IllegalArgumentException(message);
        }
    }

    public static void match(String str, String name, Pattern pattern, int maxLength) {
        if (null == str || str.isEmpty() || str.length() > maxLength || !pattern.matcher(str).matches()) {
            String message = String.format("%s does not match the desired pattern", name);
            throw new IllegalArgumentException(message);
        }
    }

    public static void inRange(int value, String name, int minInclusive, int maxInclusive) {
        MustBe.inRange((long)value, name, (long)minInclusive, (long)maxInclusive);
    }

    public static void inRange(long value, String name, long minInclusive, long maxInclusive) {
        if (value < minInclusive || value > maxInclusive) {
            String message = String.format("%s must be between %d and %d inclusive", name, minInclusive, maxInclusive);
            throw new IllegalArgumentException(message);
        }
    }

    public static void empty(Collection<?> collection, String name) {
        if (!collection.isEmpty()) {
            String message = String.format("%s must be empty", name);
            throw new IllegalArgumentException(message);
        }
    }

    public static void trueValue(boolean value, String name) {
        if (!value) {
            String message = String.format("%s must be true", name);
            throw new IllegalArgumentException(message);
        }
    }

    public static void falseValue(boolean value, String name) {
        if (value) {
            String message = String.format("%s must be false", name);
            throw new IllegalArgumentException(message);
        }
    }
}

