/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.utils;

import io.nem.core.utils.ExceptionUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public class LockFile {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Closeable tryAcquireLock(File lockFile) {
        Closeable i2;
        FileLockHandle handle = null;
        try {
            handle = new FileLockHandle(lockFile);
            for (int i2 = 0; i2 < 5; ++i2) {
                if (handle.tryLock()) {
                    FileLockHandle fileLockHandle = handle;
                    return fileLockHandle;
                }
                ExceptionUtils.propagateVoid(() -> Thread.sleep(10L));
            }
            i2 = null;
        }
        catch (IOException | OverlappingFileLockException e) {
            Closeable closeable = null;
            return closeable;
        }
        finally {
            if (null != handle && null == handle.lock) {
                try {
                    handle.close();
                }
                catch (IOException iOException) {}
            }
        }
        return i2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLocked(File lockFile) {
        try (FileLockHandle handle = new FileLockHandle(lockFile);){
            boolean bl = !handle.tryLock();
            return bl;
        }
        catch (OverlappingFileLockException e) {
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static class FileLockHandle
    implements Closeable {
        private final RandomAccessFile file;
        private FileLock lock;

        public FileLockHandle(File lockFile) throws IOException {
            this.file = new RandomAccessFile(lockFile, "rw");
        }

        private boolean tryLock() throws IOException {
            this.lock = this.file.getChannel().tryLock();
            return null != this.lock;
        }

        @Override
        public void close() throws IOException {
            if (null != this.lock) {
                this.lock.close();
            }
            this.file.close();
        }
    }
}

