/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.utils;

import io.nem.core.utils.StringEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class HexEncoder {
    public static byte[] getBytes(String hexString) {
        try {
            return HexEncoder.getBytesInternal(hexString);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] tryGetBytes(String hexString) {
        try {
            return HexEncoder.getBytesInternal(hexString);
        }
        catch (DecoderException e) {
            return null;
        }
    }

    private static byte[] getBytesInternal(String hexString) throws DecoderException {
        Hex codec = new Hex();
        String paddedHexString = 0 == hexString.length() % 2 ? hexString : "0" + hexString;
        byte[] encodedBytes = StringEncoder.getBytes(paddedHexString);
        return codec.decode(encodedBytes);
    }

    public static String getString(byte[] bytes) {
        Hex codec = new Hex();
        byte[] decodedBytes = codec.encode(bytes);
        return StringEncoder.getString(decodedBytes);
    }
}

