/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;

public class FormatUtils {
    public static DecimalFormat getDefaultDecimalFormat() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("#0.000", decimalFormatSymbols);
        format.setGroupingUsed(false);
        return format;
    }

    public static DecimalFormat getDecimalFormat(int decimalPlaces) {
        if (decimalPlaces < 0) {
            throw new IllegalArgumentException("decimalPlaces must be non-negative");
        }
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        StringBuilder builder = new StringBuilder();
        builder.append("#0");
        if (decimalPlaces > 0) {
            builder.append('.');
            char[] zeros = new char[decimalPlaces];
            Arrays.fill(zeros, '0');
            builder.append(zeros);
        }
        DecimalFormat format = new DecimalFormat(builder.toString(), decimalFormatSymbols);
        format.setGroupingUsed(false);
        return format;
    }

    public static String format(double value, int decimalPlaces) {
        DecimalFormat formatter = FormatUtils.getDecimalFormat(decimalPlaces);
        return formatter.format(value);
    }
}

