/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.utils;

import java.nio.ByteBuffer;

public class ByteUtils {
    public static long bytesToLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes, 0, 8);
        buffer.flip();
        return buffer.getLong();
    }

    public static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public static int bytesToInt(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.put(bytes, 0, 4);
        buffer.flip();
        return buffer.getInt();
    }

    public static byte[] intToBytes(int x) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(x);
        return buffer.array();
    }

    public static int isEqualConstantTime(int b, int c) {
        int result = 0;
        int xor = b ^ c;
        for (int i = 0; i < 8; ++i) {
            result |= xor >> i;
        }
        return (result ^ true) & 1;
    }

    public static int isNegativeConstantTime(int b) {
        return b >> 8 & 1;
    }

    public static String toString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        for (byte b : bytes) {
            builder.append(String.format("%02X ", (byte)(0xFF & b)));
        }
        builder.append("}");
        return builder.toString();
    }
}

