/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.math;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class SparseBitmap
implements Iterable<Integer> {
    private final EWAHCompressedBitmap bitmap;

    private SparseBitmap(EWAHCompressedBitmap bitmap) {
        this.bitmap = bitmap;
    }

    public static SparseBitmap createEmpty() {
        return new SparseBitmap(EWAHCompressedBitmap.bitmapOf((int[])new int[0]));
    }

    public static SparseBitmap createFromSortedData(int ... bitsToSet) {
        return new SparseBitmap(EWAHCompressedBitmap.bitmapOf((int[])bitsToSet));
    }

    public static SparseBitmap createFromUnsortedData(int ... bitsToSet) {
        Arrays.sort(bitsToSet);
        return new SparseBitmap(EWAHCompressedBitmap.bitmapOf((int[])bitsToSet));
    }

    public static SparseBitmap batchOr(SparseBitmap ... bitmaps) {
        if (bitmaps.length < 1) {
            return SparseBitmap.createFromUnsortedData(new int[0]);
        }
        if (bitmaps.length < 2) {
            return bitmaps[0];
        }
        EWAHCompressedBitmap firstMap = bitmaps[0].bitmap;
        for (int index = 1; index < bitmaps.length; ++index) {
            firstMap = firstMap.or(bitmaps[index].bitmap);
        }
        return new SparseBitmap(firstMap);
    }

    public boolean get(int bitToGet) {
        return this.bitmap.get(bitToGet);
    }

    public void setWithoutAscendingCheck(int bitToSet) {
        this.bitmap.set(bitToSet);
    }

    public void set(int bitToSet) {
        if (this.bitmap.cardinality() > 0 && bitToSet < this.bitmap.toArray()[this.bitmap.cardinality() - 1]) {
            throw new IllegalArgumentException("Must set bits in strictly ascending order.");
        }
        this.bitmap.set(bitToSet);
    }

    public void clear() {
        this.bitmap.clear();
    }

    public SparseBitmap or(SparseBitmap rhs) {
        return new SparseBitmap(this.bitmap.or(rhs.bitmap));
    }

    public SparseBitmap and(SparseBitmap rhs) {
        return new SparseBitmap(this.bitmap.and(rhs.bitmap));
    }

    public SparseBitmap andNot(SparseBitmap rhs) {
        return new SparseBitmap(this.bitmap.andNot(rhs.bitmap));
    }

    public int getHighestBit() {
        return this.bitmap.cardinality() > 0 ? this.bitmap.toArray()[this.bitmap.cardinality() - 1] : 0;
    }

    public int andCardinality(SparseBitmap rhs) {
        return this.bitmap.andCardinality(rhs.bitmap);
    }

    public int cardinality() {
        return this.bitmap.cardinality();
    }

    public List<Integer> toList() {
        return this.bitmap.toList();
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.bitmap.iterator();
    }

    public int hashCode() {
        return this.bitmap.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SparseBitmap)) {
            return false;
        }
        SparseBitmap rhs = (SparseBitmap)obj;
        return this.bitmap.equals((Object)rhs.bitmap);
    }

    public String toString() {
        return this.bitmap.toString();
    }
}

