/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.math;

import io.nem.core.math.DenseMatrix;
import io.nem.core.math.Matrix;
import io.nem.core.utils.FormatUtils;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.function.DoubleFunction;
import java.util.function.Supplier;
import org.apache.commons.math3.stat.descriptive.rank.Median;

public class ColumnVector {
    private final int size;
    private final double[] vector;
    private final DenseMatrix matrix;

    public ColumnVector(int size) {
        if (0 == size) {
            throw new IllegalArgumentException("cannot create a vector of zero size");
        }
        this.size = size;
        this.vector = new double[this.size];
        this.matrix = new DenseMatrix(this.size, 1, this.vector);
    }

    public ColumnVector(double ... vector) {
        if (null == vector || 0 == vector.length) {
            throw new IllegalArgumentException("vector must not be null and have a non-zero size");
        }
        this.size = vector.length;
        this.vector = vector;
        this.matrix = new DenseMatrix(this.size, 1, this.vector);
    }

    private ColumnVector(Matrix matrix) {
        this.matrix = (DenseMatrix)matrix;
        this.vector = this.matrix.getRaw();
        this.size = this.vector.length;
    }

    public int size() {
        return this.matrix.getRowCount();
    }

    public double getAt(int index) {
        return this.matrix.getAt(index, 0);
    }

    public void setAt(int index, double val) {
        this.matrix.setAt(index, 0, val);
    }

    public void incrementAt(int index, double val) {
        this.matrix.incrementAt(index, 0, val);
    }

    public void normalize() {
        this.matrix.normalizeColumns();
    }

    public void scale(double scale) {
        this.matrix.scale(scale);
    }

    public ColumnVector multiplyElementWise(ColumnVector vector) {
        return this.transform(() -> this.matrix.multiplyElementWise(vector.matrix));
    }

    public ColumnVector addElementWise(ColumnVector vector) {
        return this.transform(() -> this.matrix.addElementWise(vector.matrix));
    }

    public double absSum() {
        return this.matrix.absSum();
    }

    public double sum() {
        return this.matrix.sum();
    }

    public ColumnVector roundTo(int numPlaces) {
        return this.transform(() -> this.matrix.roundTo(numPlaces));
    }

    public ColumnVector add(double scalar) {
        return this.transform(() -> this.matrix.add(scalar));
    }

    public ColumnVector multiply(double scalar) {
        return this.transform(() -> this.matrix.multiply(scalar));
    }

    public ColumnVector sqrt() {
        return this.transform(this.matrix::sqrt);
    }

    public ColumnVector abs() {
        return this.transform(this.matrix::abs);
    }

    private ColumnVector transform(Supplier<Matrix> supplier) {
        Matrix matrix = supplier.get();
        return new ColumnVector(matrix);
    }

    public final boolean isZeroVector() {
        return this.matrix.isZeroMatrix();
    }

    public double[] getRaw() {
        return this.vector;
    }

    public void setAll(double val) {
        for (int i = 0; i < this.vector.length; ++i) {
            this.vector[i] = val;
        }
    }

    public boolean align() {
        if (0.0 == this.vector[0]) {
            return false;
        }
        this.scale(this.vector[0]);
        return true;
    }

    public double max() {
        double maxVal = this.vector[0];
        for (double val : this.vector) {
            maxVal = Math.max(maxVal, val);
        }
        return maxVal;
    }

    public double median() {
        Median median = new Median();
        return median.evaluate(this.vector);
    }

    public double getMagnitude() {
        ColumnVector nullVector = new ColumnVector(this.size);
        return this.l2Distance(nullVector);
    }

    public double l1Distance(ColumnVector vector) {
        return this.distance(vector, Math::abs);
    }

    public double l2Distance(ColumnVector vector) {
        double distance = this.distance(vector, d -> d * d);
        return Math.sqrt(distance);
    }

    private double distance(ColumnVector vector, DoubleFunction<Double> aggregate) {
        if (this.size != vector.size) {
            throw new IllegalArgumentException("cannot determine the distance between vectors with different sizes");
        }
        double distance = 0.0;
        for (int i = 0; i < this.size; ++i) {
            double difference = this.vector[i] - vector.vector[i];
            distance += aggregate.apply(difference).doubleValue();
        }
        return distance;
    }

    public double correlation(ColumnVector vector) {
        if (this.size != vector.size) {
            throw new IllegalArgumentException("cannot determine the correlation between vectors with different sizes");
        }
        ColumnVector meanAdjustedX = this.meanAdjust();
        ColumnVector meanAdjustedY = vector.meanAdjust();
        double squaredDeviationX = meanAdjustedX.multiplyElementWise(meanAdjustedX).sum();
        double squaredDeviationY = meanAdjustedY.multiplyElementWise(meanAdjustedY).sum();
        double deviationProduct = meanAdjustedX.multiplyElementWise(meanAdjustedY).sum();
        return deviationProduct / Math.sqrt(squaredDeviationX * squaredDeviationY);
    }

    private ColumnVector meanAdjust() {
        double mean = this.sum() / (double)this.size;
        return this.add(-mean);
    }

    public String toString() {
        DecimalFormat format = FormatUtils.getDefaultDecimalFormat();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            if (0 != i) {
                builder.append(" ");
            }
            builder.append(format.format(this.vector[i]));
        }
        return builder.toString();
    }

    public void removeNegatives() {
        this.matrix.removeNegatives();
    }

    public int hashCode() {
        return Arrays.hashCode(this.vector);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnVector)) {
            return false;
        }
        ColumnVector rhs = (ColumnVector)obj;
        return Arrays.equals(this.vector, rhs.vector);
    }
}

