/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.crypto.ed25519.arithmetic;

import io.nem.core.crypto.ed25519.arithmetic.Ed25519EncodedFieldElement;
import java.util.Arrays;

public class Ed25519FieldElement {
    private final int[] values;

    public Ed25519FieldElement(int[] values) {
        if (values.length != 10) {
            throw new IllegalArgumentException("Invalid 2^25.5 bit representation.");
        }
        this.values = values;
    }

    public static Ed25519FieldElement sqrt(Ed25519FieldElement u, Ed25519FieldElement v) {
        Ed25519FieldElement v3 = v.square().multiply(v);
        Ed25519FieldElement x = v3.square().multiply(v).multiply(u);
        x = x.pow2to252sub4().multiply(x);
        x = v3.multiply(u).multiply(x);
        return x;
    }

    public int[] getRaw() {
        return this.values;
    }

    public boolean isNonZero() {
        return this.encode().isNonZero();
    }

    public Ed25519FieldElement add(Ed25519FieldElement g) {
        int[] gValues = g.values;
        int[] h = new int[10];
        for (int i = 0; i < 10; ++i) {
            h[i] = this.values[i] + gValues[i];
        }
        return new Ed25519FieldElement(h);
    }

    public Ed25519FieldElement subtract(Ed25519FieldElement g) {
        int[] gValues = g.values;
        int[] h = new int[10];
        for (int i = 0; i < 10; ++i) {
            h[i] = this.values[i] - gValues[i];
        }
        return new Ed25519FieldElement(h);
    }

    public Ed25519FieldElement negate() {
        int[] h = new int[10];
        for (int i = 0; i < 10; ++i) {
            h[i] = -this.values[i];
        }
        return new Ed25519FieldElement(h);
    }

    /*
     * WARNING - void declaration
     */
    public Ed25519FieldElement multiply(Ed25519FieldElement g) {
        void h;
        void carry9;
        void carry8;
        void carry7;
        void carry3;
        void carry6;
        void carry2;
        void carry5;
        void carry1;
        long carry4;
        long carry0;
        int[] gValues = g.values;
        int f0 = this.values[0];
        int f1 = this.values[1];
        int f2 = this.values[2];
        int f3 = this.values[3];
        int f4 = this.values[4];
        int f5 = this.values[5];
        int f6 = this.values[6];
        int f7 = this.values[7];
        int f8 = this.values[8];
        int f9 = this.values[9];
        int g0 = gValues[0];
        int g1 = gValues[1];
        int g2 = gValues[2];
        int g3 = gValues[3];
        int g4 = gValues[4];
        int g5 = gValues[5];
        int g6 = gValues[6];
        int g7 = gValues[7];
        int g8 = gValues[8];
        int g9 = gValues[9];
        int g1_19 = 19 * g1;
        int g2_19 = 19 * g2;
        int g3_19 = 19 * g3;
        int g4_19 = 19 * g4;
        int g5_19 = 19 * g5;
        int g6_19 = 19 * g6;
        int g7_19 = 19 * g7;
        int g8_19 = 19 * g8;
        int g9_19 = 19 * g9;
        int f1_2 = 2 * f1;
        int f3_2 = 2 * f3;
        int f5_2 = 2 * f5;
        int f7_2 = 2 * f7;
        int f9_2 = 2 * f9;
        long f0g0 = (long)f0 * (long)g0;
        long f0g1 = (long)f0 * (long)g1;
        long f0g2 = (long)f0 * (long)g2;
        long f0g3 = (long)f0 * (long)g3;
        long f0g4 = (long)f0 * (long)g4;
        long f0g5 = (long)f0 * (long)g5;
        long f0g6 = (long)f0 * (long)g6;
        long f0g7 = (long)f0 * (long)g7;
        long f0g8 = (long)f0 * (long)g8;
        long f0g9 = (long)f0 * (long)g9;
        long f1g0 = (long)f1 * (long)g0;
        long f1g1_2 = (long)f1_2 * (long)g1;
        long f1g2 = (long)f1 * (long)g2;
        long f1g3_2 = (long)f1_2 * (long)g3;
        long f1g4 = (long)f1 * (long)g4;
        long f1g5_2 = (long)f1_2 * (long)g5;
        long f1g6 = (long)f1 * (long)g6;
        long f1g7_2 = (long)f1_2 * (long)g7;
        long f1g8 = (long)f1 * (long)g8;
        long f1g9_38 = (long)f1_2 * (long)g9_19;
        long f2g0 = (long)f2 * (long)g0;
        long f2g1 = (long)f2 * (long)g1;
        long f2g2 = (long)f2 * (long)g2;
        long f2g3 = (long)f2 * (long)g3;
        long f2g4 = (long)f2 * (long)g4;
        long f2g5 = (long)f2 * (long)g5;
        long f2g6 = (long)f2 * (long)g6;
        long f2g7 = (long)f2 * (long)g7;
        long f2g8_19 = (long)f2 * (long)g8_19;
        long f2g9_19 = (long)f2 * (long)g9_19;
        long f3g0 = (long)f3 * (long)g0;
        long f3g1_2 = (long)f3_2 * (long)g1;
        long f3g2 = (long)f3 * (long)g2;
        long f3g3_2 = (long)f3_2 * (long)g3;
        long f3g4 = (long)f3 * (long)g4;
        long f3g5_2 = (long)f3_2 * (long)g5;
        long f3g6 = (long)f3 * (long)g6;
        long f3g7_38 = (long)f3_2 * (long)g7_19;
        long f3g8_19 = (long)f3 * (long)g8_19;
        long f3g9_38 = (long)f3_2 * (long)g9_19;
        long f4g0 = (long)f4 * (long)g0;
        long f4g1 = (long)f4 * (long)g1;
        long f4g2 = (long)f4 * (long)g2;
        long f4g3 = (long)f4 * (long)g3;
        long f4g4 = (long)f4 * (long)g4;
        long f4g5 = (long)f4 * (long)g5;
        long f4g6_19 = (long)f4 * (long)g6_19;
        long f4g7_19 = (long)f4 * (long)g7_19;
        long f4g8_19 = (long)f4 * (long)g8_19;
        long f4g9_19 = (long)f4 * (long)g9_19;
        long f5g0 = (long)f5 * (long)g0;
        long f5g1_2 = (long)f5_2 * (long)g1;
        long f5g2 = (long)f5 * (long)g2;
        long f5g3_2 = (long)f5_2 * (long)g3;
        long f5g4 = (long)f5 * (long)g4;
        long f5g5_38 = (long)f5_2 * (long)g5_19;
        long f5g6_19 = (long)f5 * (long)g6_19;
        long f5g7_38 = (long)f5_2 * (long)g7_19;
        long f5g8_19 = (long)f5 * (long)g8_19;
        long f5g9_38 = (long)f5_2 * (long)g9_19;
        long f6g0 = (long)f6 * (long)g0;
        long f6g1 = (long)f6 * (long)g1;
        long f6g2 = (long)f6 * (long)g2;
        long f6g3 = (long)f6 * (long)g3;
        long f6g4_19 = (long)f6 * (long)g4_19;
        long f6g5_19 = (long)f6 * (long)g5_19;
        long f6g6_19 = (long)f6 * (long)g6_19;
        long f6g7_19 = (long)f6 * (long)g7_19;
        long f6g8_19 = (long)f6 * (long)g8_19;
        long f6g9_19 = (long)f6 * (long)g9_19;
        long f7g0 = (long)f7 * (long)g0;
        long f7g1_2 = (long)f7_2 * (long)g1;
        long f7g2 = (long)f7 * (long)g2;
        long f7g3_38 = (long)f7_2 * (long)g3_19;
        long f7g4_19 = (long)f7 * (long)g4_19;
        long f7g5_38 = (long)f7_2 * (long)g5_19;
        long f7g6_19 = (long)f7 * (long)g6_19;
        long f7g7_38 = (long)f7_2 * (long)g7_19;
        long f7g8_19 = (long)f7 * (long)g8_19;
        long f7g9_38 = (long)f7_2 * (long)g9_19;
        long f8g0 = (long)f8 * (long)g0;
        long f8g1 = (long)f8 * (long)g1;
        long f8g2_19 = (long)f8 * (long)g2_19;
        long f8g3_19 = (long)f8 * (long)g3_19;
        long f8g4_19 = (long)f8 * (long)g4_19;
        long f8g5_19 = (long)f8 * (long)g5_19;
        long f8g6_19 = (long)f8 * (long)g6_19;
        long f8g7_19 = (long)f8 * (long)g7_19;
        long f8g8_19 = (long)f8 * (long)g8_19;
        long f8g9_19 = (long)f8 * (long)g9_19;
        long f9g0 = (long)f9 * (long)g0;
        long f9g1_38 = (long)f9_2 * (long)g1_19;
        long f9g2_19 = (long)f9 * (long)g2_19;
        long f9g3_38 = (long)f9_2 * (long)g3_19;
        long f9g4_19 = (long)f9 * (long)g4_19;
        long f9g5_38 = (long)f9_2 * (long)g5_19;
        long f9g6_19 = (long)f9 * (long)g6_19;
        long f9g7_38 = (long)f9_2 * (long)g7_19;
        long f9g8_19 = (long)f9 * (long)g8_19;
        long f9g9_38 = (long)f9_2 * (long)g9_19;
        long h0 = f0g0 + f1g9_38 + f2g8_19 + f3g7_38 + f4g6_19 + f5g5_38 + f6g4_19 + f7g3_38 + f8g2_19 + f9g1_38;
        long h1 = f0g1 + f1g0 + f2g9_19 + f3g8_19 + f4g7_19 + f5g6_19 + f6g5_19 + f7g4_19 + f8g3_19 + f9g2_19;
        long h2 = f0g2 + f1g1_2 + f2g0 + f3g9_38 + f4g8_19 + f5g7_38 + f6g6_19 + f7g5_38 + f8g4_19 + f9g3_38;
        long h3 = f0g3 + f1g2 + f2g1 + f3g0 + f4g9_19 + f5g8_19 + f6g7_19 + f7g6_19 + f8g5_19 + f9g4_19;
        long h4 = f0g4 + f1g3_2 + f2g2 + f3g1_2 + f4g0 + f5g9_38 + f6g8_19 + f7g7_38 + f8g6_19 + f9g5_38;
        long h5 = f0g5 + f1g4 + f2g3 + f3g2 + f4g1 + f5g0 + f6g9_19 + f7g8_19 + f8g7_19 + f9g6_19;
        long h6 = f0g6 + f1g5_2 + f2g4 + f3g3_2 + f4g2 + f5g1_2 + f6g0 + f7g9_38 + f8g8_19 + f9g7_38;
        long h7 = f0g7 + f1g6 + f2g5 + f3g4 + f4g3 + f5g2 + f6g1 + f7g0 + f8g9_19 + f9g8_19;
        long h8 = f0g8 + f1g7_2 + f2g6 + f3g5_2 + f4g4 + f5g3_2 + f6g2 + f7g1_2 + f8g0 + f9g9_38;
        long h9 = f0g9 + f1g8 + f2g7 + f3g6 + f4g5 + f5g4 + f6g3 + f7g2 + f8g1 + f9g0;
        long l = h0 + 0x2000000L >> 26;
        h0 -= carry0 << 26;
        long l2 = h4 + 0x2000000L >> 26;
        h4 -= carry4 << 26;
        long l3 = (h1 += carry0) + 0x1000000L >> 25;
        h1 -= carry1 << 25;
        long l4 = (h5 += carry4) + 0x1000000L >> 25;
        h5 -= carry5 << 25;
        long l5 = (h2 += carry1) + 0x2000000L >> 26;
        h2 -= carry2 << 26;
        long l6 = (h6 += carry5) + 0x2000000L >> 26;
        h6 -= carry6 << 26;
        long l7 = (h3 += carry2) + 0x1000000L >> 25;
        h3 -= carry3 << 25;
        long l8 = (h7 += carry6) + 0x1000000L >> 25;
        h7 -= carry7 << 25;
        carry4 = (h4 += carry3) + 0x2000000L >> 26;
        h5 += carry4;
        h4 -= carry4 << 26;
        long l9 = (h8 += carry7) + 0x2000000L >> 26;
        h8 -= carry8 << 26;
        long l10 = (h9 += carry8) + 0x1000000L >> 25;
        h9 -= carry9 << 25;
        carry0 = (h0 += carry9 * 19L) + 0x2000000L >> 26;
        int[] nArray = new int[10];
        h[0] = (int)(h0 -= carry0 << 26);
        h[1] = (int)(h1 += carry0);
        h[2] = (int)h2;
        h[3] = (int)h3;
        h[4] = (int)h4;
        h[5] = (int)h5;
        h[6] = (int)h6;
        h[7] = (int)h7;
        h[8] = (int)h8;
        h[9] = (int)h9;
        return new Ed25519FieldElement((int[])h);
    }

    public Ed25519FieldElement square() {
        return this.squareAndOptionalDouble(false);
    }

    public Ed25519FieldElement squareAndDouble() {
        return this.squareAndOptionalDouble(true);
    }

    private Ed25519FieldElement squareAndOptionalDouble(boolean dbl) {
        int f0 = this.values[0];
        int f1 = this.values[1];
        int f2 = this.values[2];
        int f3 = this.values[3];
        int f4 = this.values[4];
        int f5 = this.values[5];
        int f6 = this.values[6];
        int f7 = this.values[7];
        int f8 = this.values[8];
        int f9 = this.values[9];
        int f0_2 = 2 * f0;
        int f1_2 = 2 * f1;
        int f2_2 = 2 * f2;
        int f3_2 = 2 * f3;
        int f4_2 = 2 * f4;
        int f5_2 = 2 * f5;
        int f6_2 = 2 * f6;
        int f7_2 = 2 * f7;
        int f5_38 = 38 * f5;
        int f6_19 = 19 * f6;
        int f7_38 = 38 * f7;
        int f8_19 = 19 * f8;
        int f9_38 = 38 * f9;
        long f0f0 = (long)f0 * (long)f0;
        long f0f1_2 = (long)f0_2 * (long)f1;
        long f0f2_2 = (long)f0_2 * (long)f2;
        long f0f3_2 = (long)f0_2 * (long)f3;
        long f0f4_2 = (long)f0_2 * (long)f4;
        long f0f5_2 = (long)f0_2 * (long)f5;
        long f0f6_2 = (long)f0_2 * (long)f6;
        long f0f7_2 = (long)f0_2 * (long)f7;
        long f0f8_2 = (long)f0_2 * (long)f8;
        long f0f9_2 = (long)f0_2 * (long)f9;
        long f1f1_2 = (long)f1_2 * (long)f1;
        long f1f2_2 = (long)f1_2 * (long)f2;
        long f1f3_4 = (long)f1_2 * (long)f3_2;
        long f1f4_2 = (long)f1_2 * (long)f4;
        long f1f5_4 = (long)f1_2 * (long)f5_2;
        long f1f6_2 = (long)f1_2 * (long)f6;
        long f1f7_4 = (long)f1_2 * (long)f7_2;
        long f1f8_2 = (long)f1_2 * (long)f8;
        long f1f9_76 = (long)f1_2 * (long)f9_38;
        long f2f2 = (long)f2 * (long)f2;
        long f2f3_2 = (long)f2_2 * (long)f3;
        long f2f4_2 = (long)f2_2 * (long)f4;
        long f2f5_2 = (long)f2_2 * (long)f5;
        long f2f6_2 = (long)f2_2 * (long)f6;
        long f2f7_2 = (long)f2_2 * (long)f7;
        long f2f8_38 = (long)f2_2 * (long)f8_19;
        long f2f9_38 = (long)f2 * (long)f9_38;
        long f3f3_2 = (long)f3_2 * (long)f3;
        long f3f4_2 = (long)f3_2 * (long)f4;
        long f3f5_4 = (long)f3_2 * (long)f5_2;
        long f3f6_2 = (long)f3_2 * (long)f6;
        long f3f7_76 = (long)f3_2 * (long)f7_38;
        long f3f8_38 = (long)f3_2 * (long)f8_19;
        long f3f9_76 = (long)f3_2 * (long)f9_38;
        long f4f4 = (long)f4 * (long)f4;
        long f4f5_2 = (long)f4_2 * (long)f5;
        long f4f6_38 = (long)f4_2 * (long)f6_19;
        long f4f7_38 = (long)f4 * (long)f7_38;
        long f4f8_38 = (long)f4_2 * (long)f8_19;
        long f4f9_38 = (long)f4 * (long)f9_38;
        long f5f5_38 = (long)f5 * (long)f5_38;
        long f5f6_38 = (long)f5_2 * (long)f6_19;
        long f5f7_76 = (long)f5_2 * (long)f7_38;
        long f5f8_38 = (long)f5_2 * (long)f8_19;
        long f5f9_76 = (long)f5_2 * (long)f9_38;
        long f6f6_19 = (long)f6 * (long)f6_19;
        long f6f7_38 = (long)f6 * (long)f7_38;
        long f6f8_38 = (long)f6_2 * (long)f8_19;
        long f6f9_38 = (long)f6 * (long)f9_38;
        long f7f7_38 = (long)f7 * (long)f7_38;
        long f7f8_38 = (long)f7_2 * (long)f8_19;
        long f7f9_76 = (long)f7_2 * (long)f9_38;
        long f8f8_19 = (long)f8 * (long)f8_19;
        long f8f9_38 = (long)f8 * (long)f9_38;
        long f9f9_38 = (long)f9 * (long)f9_38;
        long h0 = f0f0 + f1f9_76 + f2f8_38 + f3f7_76 + f4f6_38 + f5f5_38;
        long h1 = f0f1_2 + f2f9_38 + f3f8_38 + f4f7_38 + f5f6_38;
        long h2 = f0f2_2 + f1f1_2 + f3f9_76 + f4f8_38 + f5f7_76 + f6f6_19;
        long h3 = f0f3_2 + f1f2_2 + f4f9_38 + f5f8_38 + f6f7_38;
        long h4 = f0f4_2 + f1f3_4 + f2f2 + f5f9_76 + f6f8_38 + f7f7_38;
        long h5 = f0f5_2 + f1f4_2 + f2f3_2 + f6f9_38 + f7f8_38;
        long h6 = f0f6_2 + f1f5_4 + f2f4_2 + f3f3_2 + f7f9_76 + f8f8_19;
        long h7 = f0f7_2 + f1f6_2 + f2f5_2 + f3f4_2 + f8f9_38;
        long h8 = f0f8_2 + f1f7_4 + f2f6_2 + f3f5_4 + f4f4 + f9f9_38;
        long h9 = f0f9_2 + f1f8_2 + f2f7_2 + f3f6_2 + f4f5_2;
        if (dbl) {
            h0 += h0;
            h1 += h1;
            h2 += h2;
            h3 += h3;
            h4 += h4;
            h5 += h5;
            h6 += h6;
            h7 += h7;
            h8 += h8;
            h9 += h9;
        }
        long carry0 = h0 + 0x2000000L >> 26;
        h0 -= carry0 << 26;
        long carry4 = h4 + 0x2000000L >> 26;
        h4 -= carry4 << 26;
        long carry1 = (h1 += carry0) + 0x1000000L >> 25;
        h1 -= carry1 << 25;
        long carry5 = (h5 += carry4) + 0x1000000L >> 25;
        h5 -= carry5 << 25;
        long carry2 = (h2 += carry1) + 0x2000000L >> 26;
        h2 -= carry2 << 26;
        long carry6 = (h6 += carry5) + 0x2000000L >> 26;
        h6 -= carry6 << 26;
        long carry3 = (h3 += carry2) + 0x1000000L >> 25;
        h3 -= carry3 << 25;
        long carry7 = (h7 += carry6) + 0x1000000L >> 25;
        carry4 = (h4 += carry3) + 0x2000000L >> 26;
        long carry8 = (h8 += carry7) + 0x2000000L >> 26;
        long carry9 = (h9 += carry8) + 0x1000000L >> 25;
        carry0 = (h0 += carry9 * 19L) + 0x2000000L >> 26;
        int[] h = new int[]{(int)(h0 -= carry0 << 26), (int)(h1 += carry0), (int)h2, (int)h3, (int)(h4 -= carry4 << 26), (int)(h5 += carry4), (int)h6, (int)(h7 -= carry7 << 25), (int)(h8 -= carry8 << 26), (int)(h9 -= carry9 << 25)};
        return new Ed25519FieldElement(h);
    }

    public Ed25519FieldElement invert() {
        Ed25519FieldElement f0 = this.square();
        Ed25519FieldElement f1 = this.pow2to9();
        f0 = f0.multiply(f1);
        f1 = this.pow2to252sub4();
        for (int i = 1; i < 4; ++i) {
            f1 = f1.square();
        }
        return f1.multiply(f0);
    }

    private Ed25519FieldElement pow2to9() {
        Ed25519FieldElement f = this.square();
        f = f.square();
        f = f.square();
        return this.multiply(f);
    }

    private Ed25519FieldElement pow2to252sub4() {
        int i;
        Ed25519FieldElement f0 = this.square();
        Ed25519FieldElement f1 = this.pow2to9();
        f0 = f0.multiply(f1);
        f0 = f0.square();
        f0 = f1.multiply(f0);
        f1 = f0.square();
        for (i = 1; i < 5; ++i) {
            f1 = f1.square();
        }
        f0 = f1.multiply(f0);
        f1 = f0.square();
        for (i = 1; i < 10; ++i) {
            f1 = f1.square();
        }
        f1 = f1.multiply(f0);
        Ed25519FieldElement f2 = f1.square();
        for (i = 1; i < 20; ++i) {
            f2 = f2.square();
        }
        f1 = f2.multiply(f1);
        f1 = f1.square();
        for (i = 1; i < 10; ++i) {
            f1 = f1.square();
        }
        f0 = f1.multiply(f0);
        f1 = f0.square();
        for (i = 1; i < 50; ++i) {
            f1 = f1.square();
        }
        f1 = f1.multiply(f0);
        f2 = f1.square();
        for (i = 1; i < 100; ++i) {
            f2 = f2.square();
        }
        f1 = f2.multiply(f1);
        f1 = f1.square();
        for (i = 1; i < 50; ++i) {
            f1 = f1.square();
        }
        f0 = f1.multiply(f0);
        f0 = f0.square();
        return f0.square();
    }

    private Ed25519FieldElement modP() {
        int h0 = this.values[0];
        int h1 = this.values[1];
        int h2 = this.values[2];
        int h3 = this.values[3];
        int h4 = this.values[4];
        int h5 = this.values[5];
        int h6 = this.values[6];
        int h7 = this.values[7];
        int h8 = this.values[8];
        int h9 = this.values[9];
        int q = 19 * h9 + 0x1000000 >> 25;
        q = h0 + q >> 26;
        q = h1 + q >> 25;
        q = h2 + q >> 26;
        q = h3 + q >> 25;
        q = h4 + q >> 26;
        q = h5 + q >> 25;
        q = h6 + q >> 26;
        q = h7 + q >> 25;
        q = h8 + q >> 26;
        q = h9 + q >> 25;
        int carry0 = (h0 += 19 * q) >> 26;
        h0 -= carry0 << 26;
        int carry1 = (h1 += carry0) >> 25;
        h1 -= carry1 << 25;
        int carry2 = (h2 += carry1) >> 26;
        h2 -= carry2 << 26;
        int carry3 = (h3 += carry2) >> 25;
        h3 -= carry3 << 25;
        int carry4 = (h4 += carry3) >> 26;
        h4 -= carry4 << 26;
        int carry5 = (h5 += carry4) >> 25;
        h5 -= carry5 << 25;
        int carry6 = (h6 += carry5) >> 26;
        int carry7 = (h7 += carry6) >> 25;
        int carry8 = (h8 += carry7) >> 26;
        int carry9 = (h9 += carry8) >> 25;
        int[] h = new int[]{h0, h1, h2, h3, h4, h5, h6 -= carry6 << 26, h7 -= carry7 << 25, h8 -= carry8 << 26, h9 -= carry9 << 25};
        return new Ed25519FieldElement(h);
    }

    public Ed25519EncodedFieldElement encode() {
        Ed25519FieldElement g = this.modP();
        int[] gValues = g.getRaw();
        int h0 = gValues[0];
        int h1 = gValues[1];
        int h2 = gValues[2];
        int h3 = gValues[3];
        int h4 = gValues[4];
        int h5 = gValues[5];
        int h6 = gValues[6];
        int h7 = gValues[7];
        int h8 = gValues[8];
        int h9 = gValues[9];
        byte[] s = new byte[]{(byte)h0, (byte)(h0 >> 8), (byte)(h0 >> 16), (byte)(h0 >> 24 | h1 << 2), (byte)(h1 >> 6), (byte)(h1 >> 14), (byte)(h1 >> 22 | h2 << 3), (byte)(h2 >> 5), (byte)(h2 >> 13), (byte)(h2 >> 21 | h3 << 5), (byte)(h3 >> 3), (byte)(h3 >> 11), (byte)(h3 >> 19 | h4 << 6), (byte)(h4 >> 2), (byte)(h4 >> 10), (byte)(h4 >> 18), (byte)h5, (byte)(h5 >> 8), (byte)(h5 >> 16), (byte)(h5 >> 24 | h6 << 1), (byte)(h6 >> 7), (byte)(h6 >> 15), (byte)(h6 >> 23 | h7 << 3), (byte)(h7 >> 5), (byte)(h7 >> 13), (byte)(h7 >> 21 | h8 << 4), (byte)(h8 >> 4), (byte)(h8 >> 12), (byte)(h8 >> 20 | h9 << 6), (byte)(h9 >> 2), (byte)(h9 >> 10), (byte)(h9 >> 18)};
        return new Ed25519EncodedFieldElement(s);
    }

    public boolean isNegative() {
        return this.encode().isNegative();
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Ed25519FieldElement)) {
            return false;
        }
        Ed25519FieldElement f = (Ed25519FieldElement)obj;
        return this.encode().equals(f.encode());
    }

    public String toString() {
        return this.encode().toString();
    }
}

