/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.crypto.ed25519.arithmetic;

import io.nem.core.crypto.ed25519.arithmetic.Ed25519EncodedFieldElement;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519FieldElement;
import io.nem.core.utils.ArrayUtils;
import io.nem.core.utils.HexEncoder;
import java.math.BigInteger;

public class Ed25519Field {
    public static final BigInteger P = new BigInteger(HexEncoder.getBytes("7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffed"));
    public static final Ed25519FieldElement ZERO = Ed25519Field.getFieldElement(0);
    public static final Ed25519FieldElement ONE = Ed25519Field.getFieldElement(1);
    public static final Ed25519FieldElement TWO = Ed25519Field.getFieldElement(2);
    public static final Ed25519FieldElement D = Ed25519Field.getD();
    public static final Ed25519FieldElement D_Times_TWO = D.multiply(TWO);
    public static final byte[] ZERO_SHORT = new byte[32];
    public static final byte[] ZERO_LONG = new byte[64];
    public static final Ed25519FieldElement I = new Ed25519EncodedFieldElement(HexEncoder.getBytes("b0a00e4a271beec478e42fad0618432fa7d7fb3d99004d2b0bdfc14f8024832b")).decode();

    private static Ed25519FieldElement getFieldElement(int value) {
        int[] f = new int[10];
        f[0] = value;
        return new Ed25519FieldElement(f);
    }

    private static Ed25519FieldElement getD() {
        BigInteger d = new BigInteger("-121665").multiply(new BigInteger("121666").modInverse(P)).mod(P);
        return new Ed25519EncodedFieldElement(ArrayUtils.toByteArray(d, 32)).decode();
    }
}

