/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.crypto.ed25519;

import io.nem.core.crypto.CryptoException;
import io.nem.core.crypto.DsaSigner;
import io.nem.core.crypto.Hashes;
import io.nem.core.crypto.KeyPair;
import io.nem.core.crypto.Signature;
import io.nem.core.crypto.ed25519.Ed25519Utils;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519EncodedFieldElement;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519EncodedGroupElement;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519Group;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519GroupElement;
import io.nem.core.utils.ArrayUtils;
import java.math.BigInteger;
import java.util.Arrays;

public class Ed25519DsaSigner
implements DsaSigner {
    private final KeyPair keyPair;

    public Ed25519DsaSigner(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    @Override
    public Signature sign(byte[] data) {
        if (!this.getKeyPair().hasPrivateKey()) {
            throw new CryptoException("cannot sign without private key");
        }
        byte[] hash = Hashes.sha3_512(new byte[][]{this.getKeyPair().getPrivateKey().getBytes()});
        Ed25519EncodedFieldElement r = new Ed25519EncodedFieldElement(Hashes.sha3_512(Arrays.copyOfRange(hash, 32, 64), data));
        Ed25519EncodedFieldElement rModQ = r.modQ();
        Ed25519GroupElement R = Ed25519Group.BASE_POINT.scalarMultiply(rModQ);
        Ed25519EncodedGroupElement encodedR = R.encode();
        Ed25519EncodedFieldElement h = new Ed25519EncodedFieldElement(Hashes.sha3_512(encodedR.getRaw(), this.getKeyPair().getPublicKey().getRaw(), data));
        Ed25519EncodedFieldElement hModQ = h.modQ();
        Ed25519EncodedFieldElement encodedS = hModQ.multiplyAndAddModQ(Ed25519Utils.prepareForScalarMultiply(this.getKeyPair().getPrivateKey()), rModQ);
        Signature signature = new Signature(encodedR.getRaw(), encodedS.getRaw());
        if (!this.isCanonicalSignature(signature)) {
            throw new CryptoException("Generated signature is not canonical");
        }
        return signature;
    }

    @Override
    public boolean verify(byte[] data, Signature signature) {
        if (!this.isCanonicalSignature(signature)) {
            return false;
        }
        if (1 == ArrayUtils.isEqualConstantTime(this.getKeyPair().getPublicKey().getRaw(), new byte[32])) {
            return false;
        }
        byte[] rawEncodedR = signature.getBinaryR();
        byte[] rawEncodedA = this.getKeyPair().getPublicKey().getRaw();
        Ed25519EncodedFieldElement h = new Ed25519EncodedFieldElement(Hashes.sha3_512(rawEncodedR, rawEncodedA, data));
        Ed25519EncodedFieldElement hModQ = h.modQ();
        Ed25519GroupElement A = new Ed25519EncodedGroupElement(rawEncodedA).decode();
        A.precomputeForDoubleScalarMultiplication();
        Ed25519GroupElement calculatedR = Ed25519Group.BASE_POINT.doubleScalarMultiplyVariableTime(A, hModQ, new Ed25519EncodedFieldElement(signature.getBinaryS()));
        byte[] encodedCalculatedR = calculatedR.encode().getRaw();
        int result = ArrayUtils.isEqualConstantTime(encodedCalculatedR, rawEncodedR);
        return 1 == result;
    }

    @Override
    public boolean isCanonicalSignature(Signature signature) {
        return -1 == signature.getS().compareTo(Ed25519Group.GROUP_ORDER) && 1 == signature.getS().compareTo(BigInteger.ZERO);
    }

    @Override
    public Signature makeSignatureCanonical(Signature signature) {
        Ed25519EncodedFieldElement s = new Ed25519EncodedFieldElement(Arrays.copyOf(signature.getBinaryS(), 64));
        Ed25519EncodedFieldElement sModQ = s.modQ();
        return new Signature(signature.getBinaryR(), sModQ.getRaw());
    }
}

