/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.crypto.ed25519;

import io.nem.core.crypto.BlockCipher;
import io.nem.core.crypto.CryptoEngine;
import io.nem.core.crypto.Curve;
import io.nem.core.crypto.DsaSigner;
import io.nem.core.crypto.KeyAnalyzer;
import io.nem.core.crypto.KeyGenerator;
import io.nem.core.crypto.KeyPair;
import io.nem.core.crypto.ed25519.Ed25519BlockCipher;
import io.nem.core.crypto.ed25519.Ed25519Curve;
import io.nem.core.crypto.ed25519.Ed25519DsaSigner;
import io.nem.core.crypto.ed25519.Ed25519KeyAnalyzer;
import io.nem.core.crypto.ed25519.Ed25519KeyGenerator;

public class Ed25519CryptoEngine
implements CryptoEngine {
    @Override
    public Curve getCurve() {
        return Ed25519Curve.ed25519();
    }

    @Override
    public DsaSigner createDsaSigner(KeyPair keyPair) {
        return new Ed25519DsaSigner(keyPair);
    }

    @Override
    public KeyGenerator createKeyGenerator() {
        return new Ed25519KeyGenerator();
    }

    @Override
    public BlockCipher createBlockCipher(KeyPair senderKeyPair, KeyPair recipientKeyPair) {
        return new Ed25519BlockCipher(senderKeyPair, recipientKeyPair);
    }

    @Override
    public KeyAnalyzer createKeyAnalyzer() {
        return new Ed25519KeyAnalyzer();
    }
}

