/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.crypto;

import io.nem.core.crypto.CryptoEngine;
import io.nem.core.crypto.CryptoEngines;
import io.nem.core.crypto.DsaSigner;
import io.nem.core.crypto.KeyPair;
import io.nem.core.crypto.Signature;

public class Signer
implements DsaSigner {
    private final DsaSigner signer;

    public Signer(KeyPair keyPair) {
        this(keyPair, CryptoEngines.defaultEngine());
    }

    public Signer(KeyPair keyPair, CryptoEngine engine) {
        this(engine.createDsaSigner(keyPair));
    }

    public Signer(DsaSigner signer) {
        this.signer = signer;
    }

    @Override
    public Signature sign(byte[] data) {
        return this.signer.sign(data);
    }

    @Override
    public boolean verify(byte[] data, Signature signature) {
        return this.signer.verify(data, signature);
    }

    @Override
    public boolean isCanonicalSignature(Signature signature) {
        return this.signer.isCanonicalSignature(signature);
    }

    @Override
    public Signature makeSignatureCanonical(Signature signature) {
        return this.signer.makeSignatureCanonical(signature);
    }
}

