/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.crypto;

import io.nem.core.crypto.CryptoException;
import io.nem.core.utils.HexEncoder;
import java.util.Arrays;

public class PublicKey {
    private final byte[] value;

    public PublicKey(byte[] bytes) {
        this.value = bytes;
    }

    public static PublicKey fromHexString(String hex) {
        try {
            return new PublicKey(HexEncoder.getBytes(hex));
        }
        catch (IllegalArgumentException e) {
            throw new CryptoException(e);
        }
    }

    public byte[] getRaw() {
        return this.value;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PublicKey)) {
            return false;
        }
        PublicKey rhs = (PublicKey)obj;
        return Arrays.equals(this.value, rhs.value);
    }

    public String toString() {
        return HexEncoder.getString(this.value);
    }
}

