/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.crypto;

import io.nem.core.crypto.CryptoEngine;
import io.nem.core.crypto.CryptoEngines;
import io.nem.core.crypto.KeyGenerator;
import io.nem.core.crypto.PrivateKey;
import io.nem.core.crypto.PublicKey;

public class KeyPair {
    private final PrivateKey privateKey;
    private final PublicKey publicKey;

    public KeyPair() {
        KeyGenerator generator = CryptoEngines.defaultEngine().createKeyGenerator();
        KeyPair pair = generator.generateKeyPair();
        this.privateKey = pair.getPrivateKey();
        this.publicKey = pair.getPublicKey();
    }

    public KeyPair(PrivateKey privateKey) {
        this(privateKey, CryptoEngines.defaultEngine());
    }

    public KeyPair(PrivateKey privateKey, CryptoEngine engine) {
        this(privateKey, engine.createKeyGenerator().derivePublicKey(privateKey), engine);
    }

    public KeyPair(PublicKey publicKey) {
        this(publicKey, CryptoEngines.defaultEngine());
    }

    public KeyPair(PublicKey publicKey, CryptoEngine engine) {
        this(null, publicKey, engine);
    }

    private KeyPair(PrivateKey privateKey, PublicKey publicKey, CryptoEngine engine) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        if (!engine.createKeyAnalyzer().isKeyCompressed(this.publicKey)) {
            throw new IllegalArgumentException("publicKey must be in compressed form");
        }
    }

    public static KeyPair random(CryptoEngine engine) {
        KeyPair pair = engine.createKeyGenerator().generateKeyPair();
        return new KeyPair(pair.getPrivateKey(), pair.getPublicKey(), engine);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public boolean hasPrivateKey() {
        return null != this.privateKey;
    }
}

