/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.crypto;

import io.nem.core.crypto.CryptoException;
import io.nem.core.utils.ExceptionUtils;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Hashes {
    public static byte[] sha3_256(byte[] ... inputs) {
        return Hashes.hash("SHA3-256", inputs);
    }

    public static byte[] sha3_512(byte[] ... inputs) {
        return Hashes.hash("SHA3-512", inputs);
    }

    public static byte[] ripemd160(byte[] ... inputs) {
        return Hashes.hash("RIPEMD160", inputs);
    }

    private static byte[] hash(String algorithm, byte[] ... inputs) {
        return ExceptionUtils.propagate(() -> {
            MessageDigest digest = MessageDigest.getInstance(algorithm, "BC");
            for (byte[] input : inputs) {
                digest.update(input);
            }
            return digest.digest();
        }, CryptoException::new);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

