/*
 * Copyright 2018 NEM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// automatically generated by the FlatBuffers compiler, do not modify

package io.nem.sdk.model.transaction;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@SuppressWarnings("unused")
final class CosignatoryModificationBuffer extends Table {
    public static CosignatoryModificationBuffer getRootAsCosignatoryModificationBuffer(ByteBuffer _bb) {
        return getRootAsCosignatoryModificationBuffer(_bb, new CosignatoryModificationBuffer());
    }

    public static CosignatoryModificationBuffer getRootAsCosignatoryModificationBuffer(ByteBuffer _bb, CosignatoryModificationBuffer obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return (obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb));
    }

    public static int createCosignatoryModificationBuffer(FlatBufferBuilder builder,
                                                          int type,
                                                          int cosignatoryPublicKeyOffset) {
        builder.startObject(2);
        CosignatoryModificationBuffer.addCosignatoryPublicKey(builder, cosignatoryPublicKeyOffset);
        CosignatoryModificationBuffer.addType(builder, type);
        return CosignatoryModificationBuffer.endCosignatoryModificationBuffer(builder);
    }

    public static void startCosignatoryModificationBuffer(FlatBufferBuilder builder) {
        builder.startObject(2);
    }

    public static void addType(FlatBufferBuilder builder, int type) {
        builder.addByte(0, (byte) type, (byte) 0);
    }

    public static void addCosignatoryPublicKey(FlatBufferBuilder builder, int cosignatoryPublicKeyOffset) {
        builder.addOffset(1, cosignatoryPublicKeyOffset, 0);
    }

    public static int createCosignatoryPublicKeyVector(FlatBufferBuilder builder, byte[] data) {
        builder.startVector(1, data.length, 1);
        for (int i = data.length - 1; i >= 0; i--) builder.addByte(data[i]);
        return builder.endVector();
    }

    public static void startCosignatoryPublicKeyVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(1, numElems, 1);
    }

    public static int endCosignatoryModificationBuffer(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }

    public void __init(int _i, ByteBuffer _bb) {
        bb_pos = _i;
        bb = _bb;
    }

    public CosignatoryModificationBuffer __assign(int _i, ByteBuffer _bb) {
        __init(_i, _bb);
        return this;
    }

    public int type() {
        int o = __offset(4);
        return o != 0 ? bb.get(o + bb_pos) & 0xFF : 0;
    }

    public int cosignatoryPublicKey(int j) {
        int o = __offset(6);
        return o != 0 ? bb.get(__vector(o) + j * 1) & 0xFF : 0;
    }

    public int cosignatoryPublicKeyLength() {
        int o = __offset(6);
        return o != 0 ? __vector_len(o) : 0;
    }

    public ByteBuffer cosignatoryPublicKeyAsByteBuffer() {
        return __vector_as_bytebuffer(6, 1);
    }
}

