/*
 * Copyright 2018 NEM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * NIS2 API
 * This document defines all the nis2 api routes and behaviour
 *
 * OpenAPI spec version: 1.0.0
 * Contact: guillemchain@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.nem.sdk.infrastructure;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * MultisigAccountGraphInfoDTO
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-19T19:07:40.115Z")
class MultisigAccountGraphInfoDTO {
    @SerializedName("level")
    private Integer level = null;

    @SerializedName("multisigEntries")
    private List<MultisigAccountInfoDTO> multisigEntries = new ArrayList<MultisigAccountInfoDTO>();

    public MultisigAccountGraphInfoDTO level(Integer level) {
        this.level = level;
        return this;
    }

    /**
     * Get level
     *
     * @return level
     **/
    @ApiModelProperty(required = true, value = "")
    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public MultisigAccountGraphInfoDTO multisigEntries(List<MultisigAccountInfoDTO> multisigEntries) {
        this.multisigEntries = multisigEntries;
        return this;
    }

    public MultisigAccountGraphInfoDTO addMultisigEntriesItem(MultisigAccountInfoDTO multisigEntriesItem) {
        this.multisigEntries.add(multisigEntriesItem);
        return this;
    }

    /**
     * Get multisigEntries
     *
     * @return multisigEntries
     **/
    @ApiModelProperty(required = true, value = "")
    public List<MultisigAccountInfoDTO> getMultisigEntries() {
        return multisigEntries;
    }

    public void setMultisigEntries(List<MultisigAccountInfoDTO> multisigEntries) {
        this.multisigEntries = multisigEntries;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MultisigAccountGraphInfoDTO multisigAccountGraphInfoDTO = (MultisigAccountGraphInfoDTO) o;
        return Objects.equals(this.level, multisigAccountGraphInfoDTO.level) &&
                Objects.equals(this.multisigEntries, multisigAccountGraphInfoDTO.multisigEntries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(level, multisigEntries);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultisigAccountGraphInfoDTO {\n");

        sb.append("    level: ").append(toIndentedString(level)).append("\n");
        sb.append("    multisigEntries: ").append(toIndentedString(multisigEntries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}

