/*
 * Copyright 2018 NEM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * NIS2 API
 * This document defines all the nis2 api routes and behaviour
 *
 * OpenAPI spec version: 1.0.0
 * Contact: guillemchain@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.nem.sdk.infrastructure;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Multisig
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-03-08T14:38:43.120Z")
public class Multisig {
    @SerializedName("account")
    private String account = null;

    @SerializedName("accountAddress")
    private String accountAddress = null;

    @SerializedName("minApproval")
    private Integer minApproval = null;

    @SerializedName("minRemoval")
    private Integer minRemoval = null;

    @SerializedName("cosignatories")
    private List<String> cosignatories = new ArrayList<String>();

    @SerializedName("multisigAccounts")
    private List<String> multisigAccounts = new ArrayList<String>();

    public Multisig account(String account) {
        this.account = account;
        return this;
    }

    /**
     * Get account
     * @return account
     **/
    @ApiModelProperty(required = true, value = "")
    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Multisig accountAddress(String accountAddress) {
        this.accountAddress = accountAddress;
        return this;
    }

    /**
     * Get accountAddress
     * @return accountAddress
     **/
    @ApiModelProperty(value = "")
    public String getAccountAddress() {
        return accountAddress;
    }

    public void setAccountAddress(String accountAddress) {
        this.accountAddress = accountAddress;
    }

    public Multisig minApproval(Integer minApproval) {
        this.minApproval = minApproval;
        return this;
    }

    /**
     * Get minApproval
     * @return minApproval
     **/
    @ApiModelProperty(required = true, value = "")
    public Integer getMinApproval() {
        return minApproval;
    }

    public void setMinApproval(Integer minApproval) {
        this.minApproval = minApproval;
    }

    public Multisig minRemoval(Integer minRemoval) {
        this.minRemoval = minRemoval;
        return this;
    }

    /**
     * Get minRemoval
     * @return minRemoval
     **/
    @ApiModelProperty(required = true, value = "")
    public Integer getMinRemoval() {
        return minRemoval;
    }

    public void setMinRemoval(Integer minRemoval) {
        this.minRemoval = minRemoval;
    }

    public Multisig cosignatories(List<String> cosignatories) {
        this.cosignatories = cosignatories;
        return this;
    }

    public Multisig addCosignatoriesItem(String cosignatoriesItem) {
        this.cosignatories.add(cosignatoriesItem);
        return this;
    }

    /**
     * Get cosignatories
     * @return cosignatories
     **/
    @ApiModelProperty(required = true, value = "")
    public List<String> getCosignatories() {
        return cosignatories;
    }

    public void setCosignatories(List<String> cosignatories) {
        this.cosignatories = cosignatories;
    }

    public Multisig multisigAccounts(List<String> multisigAccounts) {
        this.multisigAccounts = multisigAccounts;
        return this;
    }

    public Multisig addMultisigAccountsItem(String multisigAccountsItem) {
        this.multisigAccounts.add(multisigAccountsItem);
        return this;
    }

    /**
     * Get multisigAccounts
     * @return multisigAccounts
     **/
    @ApiModelProperty(required = true, value = "")
    public List<String> getMultisigAccounts() {
        return multisigAccounts;
    }

    public void setMultisigAccounts(List<String> multisigAccounts) {
        this.multisigAccounts = multisigAccounts;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Multisig multisig = (Multisig) o;
        return Objects.equals(this.account, multisig.account) &&
                Objects.equals(this.accountAddress, multisig.accountAddress) &&
                Objects.equals(this.minApproval, multisig.minApproval) &&
                Objects.equals(this.minRemoval, multisig.minRemoval) &&
                Objects.equals(this.cosignatories, multisig.cosignatories) &&
                Objects.equals(this.multisigAccounts, multisig.multisigAccounts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(account, accountAddress, minApproval, minRemoval, cosignatories, multisigAccounts);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Multisig {\n");

        sb.append("    account: ").append(toIndentedString(account)).append("\n");
        sb.append("    accountAddress: ").append(toIndentedString(accountAddress)).append("\n");
        sb.append("    minApproval: ").append(toIndentedString(minApproval)).append("\n");
        sb.append("    minRemoval: ").append(toIndentedString(minRemoval)).append("\n");
        sb.append("    cosignatories: ").append(toIndentedString(cosignatories)).append("\n");
        sb.append("    multisigAccounts: ").append(toIndentedString(multisigAccounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}

