/*
 * Copyright 2018 NEM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * NIS2 API
 * This document defines all the nis2 api routes and behaviour
 *
 * OpenAPI spec version: 1.0.0
 * Contact: guillemchain@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.nem.sdk.infrastructure;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

/**
 * MosaicDefinitionDTO
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-19T19:07:40.115Z")
class MosaicDefinitionDTO {
    @SerializedName("namespaceId")
    private UInt64DTO namespaceId = null;

    @SerializedName("mosaicId")
    private UInt64DTO mosaicId = null;

    @SerializedName("supply")
    private UInt64DTO supply = null;

    @SerializedName("height")
    private UInt64DTO height = null;

    @SerializedName("owner")
    private String owner = null;

    @SerializedName("properties")
    private MosaicPropertiesDTO properties = null;

    @SerializedName("levy")
    private Object levy = null;

    public MosaicDefinitionDTO namespaceId(UInt64DTO namespaceId) {
        this.namespaceId = namespaceId;
        return this;
    }

    /**
     * Get namespaceId
     *
     * @return namespaceId
     **/
    @ApiModelProperty(required = true, value = "")
    public UInt64DTO getNamespaceId() {
        return namespaceId;
    }

    public void setNamespaceId(UInt64DTO namespaceId) {
        this.namespaceId = namespaceId;
    }

    public MosaicDefinitionDTO mosaicId(UInt64DTO mosaicId) {
        this.mosaicId = mosaicId;
        return this;
    }

    /**
     * Get mosaicId
     *
     * @return mosaicId
     **/
    @ApiModelProperty(required = true, value = "")
    public UInt64DTO getMosaicId() {
        return mosaicId;
    }

    public void setMosaicId(UInt64DTO mosaicId) {
        this.mosaicId = mosaicId;
    }

    public MosaicDefinitionDTO supply(UInt64DTO supply) {
        this.supply = supply;
        return this;
    }

    /**
     * Get supply
     *
     * @return supply
     **/
    @ApiModelProperty(required = true, value = "")
    public UInt64DTO getSupply() {
        return supply;
    }

    public void setSupply(UInt64DTO supply) {
        this.supply = supply;
    }

    public MosaicDefinitionDTO height(UInt64DTO height) {
        this.height = height;
        return this;
    }

    /**
     * Get height
     *
     * @return height
     **/
    @ApiModelProperty(required = true, value = "")
    public UInt64DTO getHeight() {
        return height;
    }

    public void setHeight(UInt64DTO height) {
        this.height = height;
    }

    public MosaicDefinitionDTO owner(String owner) {
        this.owner = owner;
        return this;
    }

    /**
     * Get owner
     *
     * @return owner
     **/
    @ApiModelProperty(required = true, value = "")
    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public MosaicDefinitionDTO properties(MosaicPropertiesDTO properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get properties
     *
     * @return properties
     **/
    @ApiModelProperty(required = true, value = "")
    public MosaicPropertiesDTO getProperties() {
        return properties;
    }

    public void setProperties(MosaicPropertiesDTO properties) {
        this.properties = properties;
    }

    public MosaicDefinitionDTO levy(Object levy) {
        this.levy = levy;
        return this;
    }

    /**
     * Get levy
     *
     * @return levy
     **/
    @ApiModelProperty(required = true, value = "")
    public Object getLevy() {
        return levy;
    }

    public void setLevy(Object levy) {
        this.levy = levy;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MosaicDefinitionDTO mosaicDefinitionDTO = (MosaicDefinitionDTO) o;
        return Objects.equals(this.namespaceId, mosaicDefinitionDTO.namespaceId) &&
                Objects.equals(this.mosaicId, mosaicDefinitionDTO.mosaicId) &&
                Objects.equals(this.supply, mosaicDefinitionDTO.supply) &&
                Objects.equals(this.height, mosaicDefinitionDTO.height) &&
                Objects.equals(this.owner, mosaicDefinitionDTO.owner) &&
                Objects.equals(this.properties, mosaicDefinitionDTO.properties) &&
                Objects.equals(this.levy, mosaicDefinitionDTO.levy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(namespaceId, mosaicId, supply, height, owner, properties, levy);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MosaicDefinitionDTO {\n");

        sb.append("    namespaceId: ").append(toIndentedString(namespaceId)).append("\n");
        sb.append("    mosaicId: ").append(toIndentedString(mosaicId)).append("\n");
        sb.append("    supply: ").append(toIndentedString(supply)).append("\n");
        sb.append("    height: ").append(toIndentedString(height)).append("\n");
        sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
        sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
        sb.append("    levy: ").append(toIndentedString(levy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}

