/*
 * Copyright 2018 NEM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * NIS2 API
 * This document defines all the nis2 api routes and behaviour
 *
 * OpenAPI spec version: 1.0.0
 * Contact: guillemchain@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.nem.sdk.infrastructure;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * BlockDTO
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-12-19T19:07:40.115Z")
class BlockDTO {
    @SerializedName("signature")
    private String signature = null;

    @SerializedName("signer")
    private String signer = null;

    @SerializedName("version")
    private BigDecimal version = null;

    @SerializedName("type")
    private BigDecimal type = null;

    @SerializedName("height")
    private UInt64DTO height = null;

    @SerializedName("timestamp")
    private UInt64DTO timestamp = null;

    @SerializedName("difficulty")
    private UInt64DTO difficulty = null;

    @SerializedName("previousBlockHash")
    private String previousBlockHash = null;

    @SerializedName("blockTransactionsHash")
    private String blockTransactionsHash = null;

    public BlockDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    /**
     * Get signature
     *
     * @return signature
     **/
    @ApiModelProperty(required = true, value = "")
    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public BlockDTO signer(String signer) {
        this.signer = signer;
        return this;
    }

    /**
     * Get signer
     *
     * @return signer
     **/
    @ApiModelProperty(required = true, value = "")
    public String getSigner() {
        return signer;
    }

    public void setSigner(String signer) {
        this.signer = signer;
    }

    public BlockDTO version(BigDecimal version) {
        this.version = version;
        return this;
    }

    /**
     * Get version
     *
     * @return version
     **/
    @ApiModelProperty(required = true, value = "")
    public BigDecimal getVersion() {
        return version;
    }

    public void setVersion(BigDecimal version) {
        this.version = version;
    }

    public BlockDTO type(BigDecimal type) {
        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @ApiModelProperty(required = true, value = "")
    public BigDecimal getType() {
        return type;
    }

    public void setType(BigDecimal type) {
        this.type = type;
    }

    public BlockDTO height(UInt64DTO height) {
        this.height = height;
        return this;
    }

    /**
     * Get height
     *
     * @return height
     **/
    @ApiModelProperty(required = true, value = "")
    public UInt64DTO getHeight() {
        return height;
    }

    public void setHeight(UInt64DTO height) {
        this.height = height;
    }

    public BlockDTO timestamp(UInt64DTO timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Get timestamp
     *
     * @return timestamp
     **/
    @ApiModelProperty(required = true, value = "")
    public UInt64DTO getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(UInt64DTO timestamp) {
        this.timestamp = timestamp;
    }

    public BlockDTO difficulty(UInt64DTO difficulty) {
        this.difficulty = difficulty;
        return this;
    }

    /**
     * Get difficulty
     *
     * @return difficulty
     **/
    @ApiModelProperty(required = true, value = "")
    public UInt64DTO getDifficulty() {
        return difficulty;
    }

    public void setDifficulty(UInt64DTO difficulty) {
        this.difficulty = difficulty;
    }

    public BlockDTO previousBlockHash(String previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
        return this;
    }

    /**
     * Get previousBlockHash
     *
     * @return previousBlockHash
     **/
    @ApiModelProperty(required = true, value = "")
    public String getPreviousBlockHash() {
        return previousBlockHash;
    }

    public void setPreviousBlockHash(String previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
    }

    public BlockDTO blockTransactionsHash(String blockTransactionsHash) {
        this.blockTransactionsHash = blockTransactionsHash;
        return this;
    }

    /**
     * Get blockTransactionsHash
     *
     * @return blockTransactionsHash
     **/
    @ApiModelProperty(required = true, value = "")
    public String getBlockTransactionsHash() {
        return blockTransactionsHash;
    }

    public void setBlockTransactionsHash(String blockTransactionsHash) {
        this.blockTransactionsHash = blockTransactionsHash;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BlockDTO blockDTO = (BlockDTO) o;
        return Objects.equals(this.signature, blockDTO.signature) &&
                Objects.equals(this.signer, blockDTO.signer) &&
                Objects.equals(this.version, blockDTO.version) &&
                Objects.equals(this.type, blockDTO.type) &&
                Objects.equals(this.height, blockDTO.height) &&
                Objects.equals(this.timestamp, blockDTO.timestamp) &&
                Objects.equals(this.difficulty, blockDTO.difficulty) &&
                Objects.equals(this.previousBlockHash, blockDTO.previousBlockHash) &&
                Objects.equals(this.blockTransactionsHash, blockDTO.blockTransactionsHash);
    }

    @Override
    public int hashCode() {
        return Objects.hash(signature, signer, version, type, height, timestamp, difficulty, previousBlockHash, blockTransactionsHash);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BlockDTO {\n");

        sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
        sb.append("    signer: ").append(toIndentedString(signer)).append("\n");
        sb.append("    version: ").append(toIndentedString(version)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    height: ").append(toIndentedString(height)).append("\n");
        sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
        sb.append("    difficulty: ").append(toIndentedString(difficulty)).append("\n");
        sb.append("    previousBlockHash: ").append(toIndentedString(previousBlockHash)).append("\n");
        sb.append("    blockTransactionsHash: ").append(toIndentedString(blockTransactionsHash)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}

