/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import io.nem.sdk.model.transaction.MessageBuffer;
import io.nem.sdk.model.transaction.MosaicBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class TransferTransactionBuffer
extends Table {
    TransferTransactionBuffer() {
    }

    public static TransferTransactionBuffer getRootAsTransferTransactionBuffer(ByteBuffer _bb) {
        return TransferTransactionBuffer.getRootAsTransferTransactionBuffer(_bb, new TransferTransactionBuffer());
    }

    public static TransferTransactionBuffer getRootAsTransferTransactionBuffer(ByteBuffer _bb, TransferTransactionBuffer obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public static int createTransferTransactionBuffer(FlatBufferBuilder builder, long size, int signatureOffset, int signerOffset, int version, int type, int feeOffset, int deadlineOffset, int recipientOffset, int messageSize, int numMosaics, int messageOffset, int mosaicsOffset) {
        builder.startObject(12);
        TransferTransactionBuffer.addMosaics(builder, mosaicsOffset);
        TransferTransactionBuffer.addMessage(builder, messageOffset);
        TransferTransactionBuffer.addRecipient(builder, recipientOffset);
        TransferTransactionBuffer.addDeadline(builder, deadlineOffset);
        TransferTransactionBuffer.addFee(builder, feeOffset);
        TransferTransactionBuffer.addSigner(builder, signerOffset);
        TransferTransactionBuffer.addSignature(builder, signatureOffset);
        TransferTransactionBuffer.addSize(builder, size);
        TransferTransactionBuffer.addMessageSize(builder, messageSize);
        TransferTransactionBuffer.addType(builder, type);
        TransferTransactionBuffer.addVersion(builder, version);
        TransferTransactionBuffer.addNumMosaics(builder, numMosaics);
        return TransferTransactionBuffer.endTransferTransactionBuffer(builder);
    }

    public static void startTransferTransactionBuffer(FlatBufferBuilder builder) {
        builder.startObject(12);
    }

    public static void addSize(FlatBufferBuilder builder, long size) {
        builder.addInt(0, (int)size, 0);
    }

    public static void addSignature(FlatBufferBuilder builder, int signatureOffset) {
        builder.addOffset(1, signatureOffset, 0);
    }

    public static int createSignatureVector(FlatBufferBuilder builder, byte[] data) {
        builder.startVector(1, data.length, 1);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addByte(data[i]);
        }
        return builder.endVector();
    }

    public static void startSignatureVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(1, numElems, 1);
    }

    public static void addSigner(FlatBufferBuilder builder, int signerOffset) {
        builder.addOffset(2, signerOffset, 0);
    }

    public static int createSignerVector(FlatBufferBuilder builder, byte[] data) {
        builder.startVector(1, data.length, 1);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addByte(data[i]);
        }
        return builder.endVector();
    }

    public static void startSignerVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(1, numElems, 1);
    }

    public static void addVersion(FlatBufferBuilder builder, int version) {
        builder.addShort(3, (short)version, 0);
    }

    public static void addType(FlatBufferBuilder builder, int type) {
        builder.addShort(4, (short)type, 0);
    }

    public static void addFee(FlatBufferBuilder builder, int feeOffset) {
        builder.addOffset(5, feeOffset, 0);
    }

    public static int createFeeVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startFeeVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addDeadline(FlatBufferBuilder builder, int deadlineOffset) {
        builder.addOffset(6, deadlineOffset, 0);
    }

    public static int createDeadlineVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startDeadlineVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addRecipient(FlatBufferBuilder builder, int recipientOffset) {
        builder.addOffset(7, recipientOffset, 0);
    }

    public static int createRecipientVector(FlatBufferBuilder builder, byte[] data) {
        builder.startVector(1, data.length, 1);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addByte(data[i]);
        }
        return builder.endVector();
    }

    public static void startRecipientVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(1, numElems, 1);
    }

    public static void addMessageSize(FlatBufferBuilder builder, int messageSize) {
        builder.addShort(8, (short)messageSize, 0);
    }

    public static void addNumMosaics(FlatBufferBuilder builder, int numMosaics) {
        builder.addByte(9, (byte)numMosaics, 0);
    }

    public static void addMessage(FlatBufferBuilder builder, int messageOffset) {
        builder.addOffset(10, messageOffset, 0);
    }

    public static void addMosaics(FlatBufferBuilder builder, int mosaicsOffset) {
        builder.addOffset(11, mosaicsOffset, 0);
    }

    public static int createMosaicsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startMosaicsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endTransferTransactionBuffer(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }

    public static void finishTransferTransactionBufferBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public TransferTransactionBuffer __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public long size() {
        int o = this.__offset(4);
        return o != 0 ? (long)this.bb.getInt(o + this.bb_pos) & 0xFFFFFFFFL : 0L;
    }

    public int signature(int j) {
        int o = this.__offset(6);
        return o != 0 ? this.bb.get(this.__vector(o) + j * 1) & 0xFF : 0;
    }

    public int signatureLength() {
        int o = this.__offset(6);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer signatureAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 1);
    }

    public int signer(int j) {
        int o = this.__offset(8);
        return o != 0 ? this.bb.get(this.__vector(o) + j * 1) & 0xFF : 0;
    }

    public int signerLength() {
        int o = this.__offset(8);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer signerAsByteBuffer() {
        return this.__vector_as_bytebuffer(8, 1);
    }

    public int version() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public int type() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public long fee(int j) {
        int o = this.__offset(14);
        return o != 0 ? (long)this.bb.getInt(this.__vector(o) + j * 4) & 0xFFFFFFFFL : 0L;
    }

    public int feeLength() {
        int o = this.__offset(14);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer feeAsByteBuffer() {
        return this.__vector_as_bytebuffer(14, 4);
    }

    public long deadline(int j) {
        int o = this.__offset(16);
        return o != 0 ? (long)this.bb.getInt(this.__vector(o) + j * 4) & 0xFFFFFFFFL : 0L;
    }

    public int deadlineLength() {
        int o = this.__offset(16);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer deadlineAsByteBuffer() {
        return this.__vector_as_bytebuffer(16, 4);
    }

    public int recipient(int j) {
        int o = this.__offset(18);
        return o != 0 ? this.bb.get(this.__vector(o) + j * 1) & 0xFF : 0;
    }

    public int recipientLength() {
        int o = this.__offset(18);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer recipientAsByteBuffer() {
        return this.__vector_as_bytebuffer(18, 1);
    }

    public int messageSize() {
        int o = this.__offset(20);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public int numMosaics() {
        int o = this.__offset(22);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public MessageBuffer message() {
        return this.message(new MessageBuffer());
    }

    public MessageBuffer message(MessageBuffer obj) {
        int o = this.__offset(24);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public MosaicBuffer mosaics(int j) {
        return this.mosaics(new MosaicBuffer(), j);
    }

    public MosaicBuffer mosaics(MosaicBuffer obj, int j) {
        int o = this.__offset(26);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int mosaicsLength() {
        int o = this.__offset(26);
        return o != 0 ? this.__vector_len(o) : 0;
    }
}

