/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import com.google.flatbuffers.FlatBufferBuilder;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.Mosaic;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.HashType;
import io.nem.sdk.model.transaction.Schema;
import io.nem.sdk.model.transaction.SecretLockTransactionBuffer;
import io.nem.sdk.model.transaction.SecretLockTransactionSchema;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.model.transaction.UInt64;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.util.encoders.Hex;

public class SecretLockTransaction
extends Transaction {
    private final Mosaic mosaic;
    private final BigInteger duration;
    private final HashType hashType;
    private final String secret;
    private final Address recipient;
    private final Schema schema = new SecretLockTransactionSchema();

    public SecretLockTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, Mosaic mosaic, BigInteger duration, HashType hashType, String secret, Address recipient, String signature, PublicAccount signer, TransactionInfo transactionInfo) {
        this(networkType, version, deadline, fee, mosaic, duration, hashType, secret, recipient, Optional.of(signature), Optional.of(signer), Optional.of(transactionInfo));
    }

    public SecretLockTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, Mosaic mosaic, BigInteger duration, HashType hashType, String secret, Address recipient) {
        this(networkType, version, deadline, fee, mosaic, duration, hashType, secret, recipient, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public SecretLockTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, Mosaic mosaic, BigInteger duration, HashType hashType, String secret, Address recipient, Optional<String> signature, Optional<PublicAccount> signer, Optional<TransactionInfo> transactionInfo) {
        super(TransactionType.SECRET_LOCK, networkType, version, deadline, fee, signature, signer, transactionInfo);
        Validate.notNull((Object)mosaic, (String)"Mosaic must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)duration, (String)"Duration must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)secret, (String)"Secret must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)recipient, (String)"Recipient must not be null", (Object[])new Object[0]);
        if (!HashType.Validator(hashType, secret)) {
            throw new IllegalArgumentException("HashType and Secret have incompatible length or not hexadecimal string");
        }
        this.mosaic = mosaic;
        this.duration = duration;
        this.hashType = hashType;
        this.secret = secret;
        this.recipient = recipient;
    }

    public static SecretLockTransaction create(Deadline deadline, Mosaic mosaic, BigInteger duration, HashType hashType, String secret, Address recipient, NetworkType networkType) {
        return new SecretLockTransaction(networkType, 3, deadline, BigInteger.valueOf(0L), mosaic, duration, hashType, secret, recipient);
    }

    public Mosaic getMosaic() {
        return this.mosaic;
    }

    public BigInteger getDuration() {
        return this.duration;
    }

    public HashType getHashType() {
        return this.hashType;
    }

    public String getSecret() {
        return this.secret;
    }

    public Address getRecipient() {
        return this.recipient;
    }

    @Override
    byte[] generateBytes() {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        BigInteger deadlineBigInt = BigInteger.valueOf(this.getDeadline().getInstant());
        int[] fee = new int[]{0, 0};
        int version = (int)Long.parseLong(Integer.toHexString(this.getNetworkType().getValue()) + "0" + Integer.toHexString(this.getVersion()), 16);
        int signatureVector = SecretLockTransactionBuffer.createSignatureVector(builder, new byte[64]);
        int signerVector = SecretLockTransactionBuffer.createSignerVector(builder, new byte[32]);
        int deadlineVector = SecretLockTransactionBuffer.createDeadlineVector(builder, UInt64.fromBigInteger(deadlineBigInt));
        int feeVector = SecretLockTransactionBuffer.createFeeVector(builder, fee);
        int mosaicIdVector = SecretLockTransactionBuffer.createMosaicIdVector(builder, UInt64.fromBigInteger(this.mosaic.getId().getId()));
        int mosaicAmountVector = SecretLockTransactionBuffer.createMosaicAmountVector(builder, UInt64.fromBigInteger(this.mosaic.getAmount()));
        int durationVector = SecretLockTransactionBuffer.createDurationVector(builder, UInt64.fromBigInteger(this.duration));
        int secretVector = SecretLockTransactionBuffer.createSecretVector(builder, Hex.decode((String)this.secret));
        byte[] address = new Base32().decode(this.getRecipient().plain().getBytes(StandardCharsets.UTF_8));
        int recipientVector = SecretLockTransactionBuffer.createRecipientVector(builder, address);
        SecretLockTransactionBuffer.startSecretLockTransactionBuffer(builder);
        SecretLockTransactionBuffer.addSize(builder, 234L);
        SecretLockTransactionBuffer.addSignature(builder, signatureVector);
        SecretLockTransactionBuffer.addSigner(builder, signerVector);
        SecretLockTransactionBuffer.addVersion(builder, version);
        SecretLockTransactionBuffer.addType(builder, this.getType().getValue());
        SecretLockTransactionBuffer.addFee(builder, feeVector);
        SecretLockTransactionBuffer.addDeadline(builder, deadlineVector);
        SecretLockTransactionBuffer.addMosaicId(builder, mosaicIdVector);
        SecretLockTransactionBuffer.addMosaicAmount(builder, mosaicAmountVector);
        SecretLockTransactionBuffer.addDuration(builder, durationVector);
        SecretLockTransactionBuffer.addHashAlgorithm(builder, this.hashType.getValue());
        SecretLockTransactionBuffer.addSecret(builder, secretVector);
        SecretLockTransactionBuffer.addRecipient(builder, recipientVector);
        int codedSecretLock = SecretLockTransactionBuffer.endSecretLockTransactionBuffer(builder);
        builder.finish(codedSecretLock);
        return this.schema.serialize(builder.sizedByteArray());
    }
}

