/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class MosaicSupplyChangeTransactionBuffer
extends Table {
    MosaicSupplyChangeTransactionBuffer() {
    }

    public static MosaicSupplyChangeTransactionBuffer getRootAsMosaicSupplyChangeTransactionBuffer(ByteBuffer _bb) {
        return MosaicSupplyChangeTransactionBuffer.getRootAsMosaicSupplyChangeTransactionBuffer(_bb, new MosaicSupplyChangeTransactionBuffer());
    }

    public static MosaicSupplyChangeTransactionBuffer getRootAsMosaicSupplyChangeTransactionBuffer(ByteBuffer _bb, MosaicSupplyChangeTransactionBuffer obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public static int createMosaicSupplyChangeTransactionBuffer(FlatBufferBuilder builder, long size, int signatureOffset, int signerOffset, int version, int type, int feeOffset, int deadlineOffset, int mosaicIdOffset, int direction, int deltaOffset) {
        builder.startObject(10);
        MosaicSupplyChangeTransactionBuffer.addDelta(builder, deltaOffset);
        MosaicSupplyChangeTransactionBuffer.addMosaicId(builder, mosaicIdOffset);
        MosaicSupplyChangeTransactionBuffer.addDeadline(builder, deadlineOffset);
        MosaicSupplyChangeTransactionBuffer.addFee(builder, feeOffset);
        MosaicSupplyChangeTransactionBuffer.addSigner(builder, signerOffset);
        MosaicSupplyChangeTransactionBuffer.addSignature(builder, signatureOffset);
        MosaicSupplyChangeTransactionBuffer.addSize(builder, size);
        MosaicSupplyChangeTransactionBuffer.addType(builder, type);
        MosaicSupplyChangeTransactionBuffer.addVersion(builder, version);
        MosaicSupplyChangeTransactionBuffer.addDirection(builder, direction);
        return MosaicSupplyChangeTransactionBuffer.endMosaicSupplyChangeTransactionBuffer(builder);
    }

    public static void startMosaicSupplyChangeTransactionBuffer(FlatBufferBuilder builder) {
        builder.startObject(10);
    }

    public static void addSize(FlatBufferBuilder builder, long size) {
        builder.addInt(0, (int)size, 0);
    }

    public static void addSignature(FlatBufferBuilder builder, int signatureOffset) {
        builder.addOffset(1, signatureOffset, 0);
    }

    public static int createSignatureVector(FlatBufferBuilder builder, byte[] data) {
        builder.startVector(1, data.length, 1);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addByte(data[i]);
        }
        return builder.endVector();
    }

    public static void startSignatureVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(1, numElems, 1);
    }

    public static void addSigner(FlatBufferBuilder builder, int signerOffset) {
        builder.addOffset(2, signerOffset, 0);
    }

    public static int createSignerVector(FlatBufferBuilder builder, byte[] data) {
        builder.startVector(1, data.length, 1);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addByte(data[i]);
        }
        return builder.endVector();
    }

    public static void startSignerVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(1, numElems, 1);
    }

    public static void addVersion(FlatBufferBuilder builder, int version) {
        builder.addShort(3, (short)version, 0);
    }

    public static void addType(FlatBufferBuilder builder, int type) {
        builder.addShort(4, (short)type, 0);
    }

    public static void addFee(FlatBufferBuilder builder, int feeOffset) {
        builder.addOffset(5, feeOffset, 0);
    }

    public static int createFeeVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startFeeVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addDeadline(FlatBufferBuilder builder, int deadlineOffset) {
        builder.addOffset(6, deadlineOffset, 0);
    }

    public static int createDeadlineVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startDeadlineVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addMosaicId(FlatBufferBuilder builder, int mosaicIdOffset) {
        builder.addOffset(7, mosaicIdOffset, 0);
    }

    public static int createMosaicIdVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startMosaicIdVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addDirection(FlatBufferBuilder builder, int direction) {
        builder.addByte(8, (byte)direction, 0);
    }

    public static void addDelta(FlatBufferBuilder builder, int deltaOffset) {
        builder.addOffset(9, deltaOffset, 0);
    }

    public static int createDeltaVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startDeltaVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endMosaicSupplyChangeTransactionBuffer(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }

    public static void finishMosaicSupplyChangeTransactionBufferBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public MosaicSupplyChangeTransactionBuffer __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public long size() {
        int o = this.__offset(4);
        return o != 0 ? (long)this.bb.getInt(o + this.bb_pos) & 0xFFFFFFFFL : 0L;
    }

    public int signature(int j) {
        int o = this.__offset(6);
        return o != 0 ? this.bb.get(this.__vector(o) + j * 1) & 0xFF : 0;
    }

    public int signatureLength() {
        int o = this.__offset(6);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer signatureAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 1);
    }

    public int signer(int j) {
        int o = this.__offset(8);
        return o != 0 ? this.bb.get(this.__vector(o) + j * 1) & 0xFF : 0;
    }

    public int signerLength() {
        int o = this.__offset(8);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer signerAsByteBuffer() {
        return this.__vector_as_bytebuffer(8, 1);
    }

    public int version() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public int type() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public long fee(int j) {
        int o = this.__offset(14);
        return o != 0 ? (long)this.bb.getInt(this.__vector(o) + j * 4) & 0xFFFFFFFFL : 0L;
    }

    public int feeLength() {
        int o = this.__offset(14);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer feeAsByteBuffer() {
        return this.__vector_as_bytebuffer(14, 4);
    }

    public long deadline(int j) {
        int o = this.__offset(16);
        return o != 0 ? (long)this.bb.getInt(this.__vector(o) + j * 4) & 0xFFFFFFFFL : 0L;
    }

    public int deadlineLength() {
        int o = this.__offset(16);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer deadlineAsByteBuffer() {
        return this.__vector_as_bytebuffer(16, 4);
    }

    public long mosaicId(int j) {
        int o = this.__offset(18);
        return o != 0 ? (long)this.bb.getInt(this.__vector(o) + j * 4) & 0xFFFFFFFFL : 0L;
    }

    public int mosaicIdLength() {
        int o = this.__offset(18);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer mosaicIdAsByteBuffer() {
        return this.__vector_as_bytebuffer(18, 4);
    }

    public int direction() {
        int o = this.__offset(20);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public long delta(int j) {
        int o = this.__offset(22);
        return o != 0 ? (long)this.bb.getInt(this.__vector(o) + j * 4) & 0xFFFFFFFFL : 0L;
    }

    public int deltaLength() {
        int o = this.__offset(22);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer deltaAsByteBuffer() {
        return this.__vector_as_bytebuffer(22, 4);
    }
}

