/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import com.google.flatbuffers.FlatBufferBuilder;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.mosaic.MosaicSupplyType;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.MosaicSupplyChangeTransactionBuffer;
import io.nem.sdk.model.transaction.MosaicSupplyChangeTransactionSchema;
import io.nem.sdk.model.transaction.Schema;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.model.transaction.UInt64;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class MosaicSupplyChangeTransaction
extends Transaction {
    private final MosaicId mosaicId;
    private final MosaicSupplyType mosaicSupplyType;
    private final BigInteger delta;
    private final Schema schema = new MosaicSupplyChangeTransactionSchema();

    public MosaicSupplyChangeTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, MosaicId mosaicId, MosaicSupplyType mosaicSupplyType, BigInteger delta, String signature, PublicAccount signer, TransactionInfo transactionInfo) {
        this(networkType, version, deadline, fee, mosaicId, mosaicSupplyType, delta, Optional.of(signature), Optional.of(signer), Optional.of(transactionInfo));
    }

    public MosaicSupplyChangeTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, MosaicId mosaicId, MosaicSupplyType mosaicSupplyType, BigInteger delta) {
        this(networkType, version, deadline, fee, mosaicId, mosaicSupplyType, delta, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private MosaicSupplyChangeTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, MosaicId mosaicId, MosaicSupplyType mosaicSupplyType, BigInteger delta, Optional<String> signature, Optional<PublicAccount> signer, Optional<TransactionInfo> transactionInfo) {
        super(TransactionType.MOSAIC_SUPPLY_CHANGE, networkType, version, deadline, fee, signature, signer, transactionInfo);
        Validate.notNull((Object)mosaicId, (String)"MosaicId must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)mosaicSupplyType), (String)"MosaicSupplyType must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)delta, (String)"Delta must not be null", (Object[])new Object[0]);
        this.mosaicId = mosaicId;
        this.mosaicSupplyType = mosaicSupplyType;
        this.delta = delta;
    }

    public static MosaicSupplyChangeTransaction create(Deadline deadline, MosaicId mosaicId, MosaicSupplyType mosaicSupplyType, BigInteger delta, NetworkType networkType) {
        return new MosaicSupplyChangeTransaction(networkType, 2, deadline, BigInteger.valueOf(0L), mosaicId, mosaicSupplyType, delta);
    }

    public MosaicId getMosaicId() {
        return this.mosaicId;
    }

    public MosaicSupplyType getMosaicSupplyType() {
        return this.mosaicSupplyType;
    }

    public BigInteger getDelta() {
        return this.delta;
    }

    @Override
    byte[] generateBytes() {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        BigInteger deadlineBigInt = BigInteger.valueOf(this.getDeadline().getInstant());
        int[] fee = new int[]{0, 0};
        int version = (int)Long.parseLong(Integer.toHexString(this.getNetworkType().getValue()) + "0" + Integer.toHexString(this.getVersion()), 16);
        int signatureVector = MosaicSupplyChangeTransactionBuffer.createSignatureVector(builder, new byte[64]);
        int signerVector = MosaicSupplyChangeTransactionBuffer.createSignerVector(builder, new byte[32]);
        int deadlineVector = MosaicSupplyChangeTransactionBuffer.createDeadlineVector(builder, UInt64.fromBigInteger(deadlineBigInt));
        int feeVector = MosaicSupplyChangeTransactionBuffer.createFeeVector(builder, fee);
        int mosaicIdVector = MosaicSupplyChangeTransactionBuffer.createMosaicIdVector(builder, UInt64.fromBigInteger(this.mosaicId.getId()));
        int deltaVector = MosaicSupplyChangeTransactionBuffer.createDeltaVector(builder, UInt64.fromBigInteger(this.delta));
        int fixSize = 137;
        MosaicSupplyChangeTransactionBuffer.startMosaicSupplyChangeTransactionBuffer(builder);
        MosaicSupplyChangeTransactionBuffer.addSize(builder, fixSize);
        MosaicSupplyChangeTransactionBuffer.addSignature(builder, signatureVector);
        MosaicSupplyChangeTransactionBuffer.addSigner(builder, signerVector);
        MosaicSupplyChangeTransactionBuffer.addVersion(builder, version);
        MosaicSupplyChangeTransactionBuffer.addType(builder, this.getType().getValue());
        MosaicSupplyChangeTransactionBuffer.addFee(builder, feeVector);
        MosaicSupplyChangeTransactionBuffer.addDeadline(builder, deadlineVector);
        MosaicSupplyChangeTransactionBuffer.addMosaicId(builder, mosaicIdVector);
        MosaicSupplyChangeTransactionBuffer.addDirection(builder, this.mosaicSupplyType.getValue());
        MosaicSupplyChangeTransactionBuffer.addDelta(builder, deltaVector);
        int codedTransaction = MosaicSupplyChangeTransactionBuffer.endMosaicSupplyChangeTransactionBuffer(builder);
        builder.finish(codedTransaction);
        return this.schema.serialize(builder.sizedByteArray());
    }
}

