/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import com.google.flatbuffers.FlatBufferBuilder;
import io.nem.core.utils.HexEncoder;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.CosignatoryModificationBuffer;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.ModifyMultisigAccountTransactionSchema;
import io.nem.sdk.model.transaction.MultisigAggregateModificationTransactionBuffer;
import io.nem.sdk.model.transaction.MultisigCosignatoryModification;
import io.nem.sdk.model.transaction.Schema;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.model.transaction.TransferTransactionBuffer;
import io.nem.sdk.model.transaction.UInt64;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class ModifyMultisigAccountTransaction
extends Transaction {
    private final int minApprovalDelta;
    private final int minRemovalDelta;
    private final List<MultisigCosignatoryModification> modifications;
    private final Schema schema = new ModifyMultisigAccountTransactionSchema();

    public ModifyMultisigAccountTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, int minApprovalDelta, int minRemovalDelta, List<MultisigCosignatoryModification> modifications, String signature, PublicAccount signer, TransactionInfo transactionInfo) {
        this(networkType, version, deadline, fee, minApprovalDelta, minRemovalDelta, modifications, Optional.of(signature), Optional.of(signer), Optional.of(transactionInfo));
    }

    public ModifyMultisigAccountTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, int minApprovalDelta, int minRemovalDelta, List<MultisigCosignatoryModification> modifications) {
        this(networkType, version, deadline, fee, minApprovalDelta, minRemovalDelta, modifications, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private ModifyMultisigAccountTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, int minApprovalDelta, int minRemovalDelta, List<MultisigCosignatoryModification> modifications, Optional<String> signature, Optional<PublicAccount> signer, Optional<TransactionInfo> transactionInfo) {
        super(TransactionType.MODIFY_MULTISIG_ACCOUNT, networkType, version, deadline, fee, signature, signer, transactionInfo);
        Validate.notNull(modifications, (String)"Modifications must not be null", (Object[])new Object[0]);
        this.minApprovalDelta = minApprovalDelta;
        this.minRemovalDelta = minRemovalDelta;
        this.modifications = modifications;
    }

    public static ModifyMultisigAccountTransaction create(Deadline deadline, int minApprovalDelta, int minRemovalDelta, List<MultisigCosignatoryModification> modifications, NetworkType networkType) {
        return new ModifyMultisigAccountTransaction(networkType, 3, deadline, BigInteger.valueOf(0L), minApprovalDelta, minRemovalDelta, modifications);
    }

    public int getMinApprovalDelta() {
        return this.minApprovalDelta;
    }

    public int getMinRemovalDelta() {
        return this.minRemovalDelta;
    }

    public List<MultisigCosignatoryModification> getModifications() {
        return this.modifications;
    }

    @Override
    byte[] generateBytes() {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        BigInteger deadlineBigInt = BigInteger.valueOf(this.getDeadline().getInstant());
        int[] fee = new int[]{0, 0};
        int version = (int)Long.parseLong(Integer.toHexString(this.getNetworkType().getValue()) + "0" + Integer.toHexString(this.getVersion()), 16);
        int[] modificationsBuffers = new int[this.modifications.size()];
        for (int i = 0; i < this.modifications.size(); ++i) {
            MultisigCosignatoryModification multisigCosignatoryModification = this.modifications.get(i);
            byte[] byteCosignatoryPublicKey = HexEncoder.getBytes(multisigCosignatoryModification.getCosignatoryPublicAccount().getPublicKey());
            int cosignatoryPublicKey = CosignatoryModificationBuffer.createCosignatoryPublicKeyVector(builder, byteCosignatoryPublicKey);
            CosignatoryModificationBuffer.startCosignatoryModificationBuffer(builder);
            CosignatoryModificationBuffer.addType(builder, multisigCosignatoryModification.getType().getValue());
            CosignatoryModificationBuffer.addCosignatoryPublicKey(builder, cosignatoryPublicKey);
            modificationsBuffers[i] = CosignatoryModificationBuffer.endCosignatoryModificationBuffer(builder);
        }
        int signatureVector = MultisigAggregateModificationTransactionBuffer.createSignatureVector(builder, new byte[64]);
        int signerVector = MultisigAggregateModificationTransactionBuffer.createSignerVector(builder, new byte[32]);
        int deadlineVector = MultisigAggregateModificationTransactionBuffer.createDeadlineVector(builder, UInt64.fromBigInteger(deadlineBigInt));
        int feeVector = MultisigAggregateModificationTransactionBuffer.createFeeVector(builder, fee);
        int modificationsVector = TransferTransactionBuffer.createMosaicsVector(builder, modificationsBuffers);
        int fixSize = 123;
        MultisigAggregateModificationTransactionBuffer.startMultisigAggregateModificationTransactionBuffer(builder);
        MultisigAggregateModificationTransactionBuffer.addSize(builder, fixSize + 33 * this.modifications.size());
        MultisigAggregateModificationTransactionBuffer.addSignature(builder, signatureVector);
        MultisigAggregateModificationTransactionBuffer.addSigner(builder, signerVector);
        MultisigAggregateModificationTransactionBuffer.addVersion(builder, version);
        MultisigAggregateModificationTransactionBuffer.addType(builder, this.getType().getValue());
        MultisigAggregateModificationTransactionBuffer.addFee(builder, feeVector);
        MultisigAggregateModificationTransactionBuffer.addDeadline(builder, deadlineVector);
        MultisigAggregateModificationTransactionBuffer.addMinApprovalDelta(builder, this.minApprovalDelta);
        MultisigAggregateModificationTransactionBuffer.addMinRemovalDelta(builder, this.minRemovalDelta);
        MultisigAggregateModificationTransactionBuffer.addNumModifications(builder, this.modifications.size());
        MultisigAggregateModificationTransactionBuffer.addModifications(builder, modificationsVector);
        int codedTransaction = MultisigAggregateModificationTransactionBuffer.endMultisigAggregateModificationTransactionBuffer(builder);
        builder.finish(codedTransaction);
        return this.schema.serialize(builder.sizedByteArray());
    }
}

