/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import com.google.flatbuffers.FlatBufferBuilder;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.Mosaic;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.LockFundsTransactionBuffer;
import io.nem.sdk.model.transaction.LockFundsTransactionSchema;
import io.nem.sdk.model.transaction.Schema;
import io.nem.sdk.model.transaction.SignedTransaction;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.model.transaction.UInt64;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.util.encoders.Hex;

public class LockFundsTransaction
extends Transaction {
    private final Mosaic mosaic;
    private final BigInteger duration;
    private final SignedTransaction signedTransaction;
    private final Schema schema = new LockFundsTransactionSchema();

    public LockFundsTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, Mosaic mosaic, BigInteger duration, SignedTransaction signedTransaction, String signature, PublicAccount signer, TransactionInfo transactionInfo) {
        this(networkType, version, deadline, fee, mosaic, duration, signedTransaction, Optional.of(signature), Optional.of(signer), Optional.of(transactionInfo));
    }

    public LockFundsTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, Mosaic mosaic, BigInteger duration, SignedTransaction signedTransaction) {
        this(networkType, version, deadline, fee, mosaic, duration, signedTransaction, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private LockFundsTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, Mosaic mosaic, BigInteger duration, SignedTransaction signedTransaction, Optional<String> signature, Optional<PublicAccount> signer, Optional<TransactionInfo> transactionInfo) {
        super(TransactionType.LOCK, networkType, version, deadline, fee, signature, signer, transactionInfo);
        Validate.notNull((Object)mosaic, (String)"Mosaic must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)duration, (String)"Duration must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)signedTransaction, (String)"Signed transaction must not be null", (Object[])new Object[0]);
        this.mosaic = mosaic;
        this.duration = duration;
        this.signedTransaction = signedTransaction;
        if (signedTransaction.getType() != TransactionType.AGGREGATE_BONDED) {
            throw new IllegalArgumentException("Signed transaction must be Aggregate Bonded Transaction");
        }
    }

    public static LockFundsTransaction create(Deadline deadline, Mosaic mosaic, BigInteger duration, SignedTransaction signedTransaction, NetworkType networkType) {
        return new LockFundsTransaction(networkType, 3, deadline, BigInteger.valueOf(0L), mosaic, duration, signedTransaction);
    }

    public Mosaic getMosaic() {
        return this.mosaic;
    }

    public BigInteger getDuration() {
        return this.duration;
    }

    public SignedTransaction getSignedTransaction() {
        return this.signedTransaction;
    }

    @Override
    byte[] generateBytes() {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        BigInteger deadlineBigInt = BigInteger.valueOf(this.getDeadline().getInstant());
        int[] fee = new int[]{0, 0};
        int version = (int)Long.parseLong(Integer.toHexString(this.getNetworkType().getValue()) + "0" + Integer.toHexString(this.getVersion()), 16);
        int signatureVector = LockFundsTransactionBuffer.createSignatureVector(builder, new byte[64]);
        int signerVector = LockFundsTransactionBuffer.createSignerVector(builder, new byte[32]);
        int deadlineVector = LockFundsTransactionBuffer.createDeadlineVector(builder, UInt64.fromBigInteger(deadlineBigInt));
        int feeVector = LockFundsTransactionBuffer.createFeeVector(builder, fee);
        int mosaicIdVector = LockFundsTransactionBuffer.createMosaicIdVector(builder, UInt64.fromBigInteger(this.mosaic.getId().getId()));
        int mosaicAmountVector = LockFundsTransactionBuffer.createMosaicAmountVector(builder, UInt64.fromBigInteger(this.mosaic.getAmount()));
        int durationVector = LockFundsTransactionBuffer.createDurationVector(builder, UInt64.fromBigInteger(this.duration));
        int hashVector = LockFundsTransactionBuffer.createHashVector(builder, Hex.decode((String)this.signedTransaction.getHash()));
        LockFundsTransactionBuffer.startLockFundsTransactionBuffer(builder);
        LockFundsTransactionBuffer.addSize(builder, 176L);
        LockFundsTransactionBuffer.addSignature(builder, signatureVector);
        LockFundsTransactionBuffer.addSigner(builder, signerVector);
        LockFundsTransactionBuffer.addVersion(builder, version);
        LockFundsTransactionBuffer.addType(builder, this.getType().getValue());
        LockFundsTransactionBuffer.addFee(builder, feeVector);
        LockFundsTransactionBuffer.addDeadline(builder, deadlineVector);
        LockFundsTransactionBuffer.addMosaicId(builder, mosaicIdVector);
        LockFundsTransactionBuffer.addMosaicAmount(builder, mosaicAmountVector);
        LockFundsTransactionBuffer.addDuration(builder, durationVector);
        LockFundsTransactionBuffer.addHash(builder, hashVector);
        int codedLockFunds = LockFundsTransactionBuffer.endLockFundsTransactionBuffer(builder);
        builder.finish(codedLockFunds);
        return this.schema.serialize(builder.sizedByteArray());
    }
}

