/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import io.nem.core.crypto.Hashes;
import io.nem.sdk.model.mosaic.IllegalIdentifierException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;

public class IdGenerator {
    public static BigInteger generateId(String name, BigInteger parentId) {
        byte[] parentIdBytes = new byte[8];
        ByteBuffer.wrap(parentIdBytes).put(parentId.toByteArray());
        ArrayUtils.reverse((byte[])parentIdBytes);
        byte[] bytes = name.getBytes();
        byte[] result = Hashes.sha3_256(parentIdBytes, bytes);
        byte[] low = Arrays.copyOfRange(result, 0, 4);
        byte[] high = Arrays.copyOfRange(result, 4, 8);
        ArrayUtils.reverse((byte[])low);
        ArrayUtils.reverse((byte[])high);
        byte[] last = ArrayUtils.addAll((byte[])high, (byte[])low);
        return new BigInteger(last);
    }

    public static List<BigInteger> generateNamespacePath(String name) {
        String[] parts = name.split(Pattern.quote("."));
        ArrayList<BigInteger> path = new ArrayList<BigInteger>();
        if (parts.length == 0) {
            throw new IllegalIdentifierException("invalid namespace name");
        }
        if (parts.length > 3) {
            throw new IllegalIdentifierException("too many parts");
        }
        BigInteger namespaceId = BigInteger.valueOf(0L);
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].matches("^[a-z0-9][a-z0-9-_]*$")) {
                throw new IllegalIdentifierException("invalid namespace name");
            }
            namespaceId = IdGenerator.generateId(parts[i], namespaceId);
            path.add(namespaceId);
        }
        return path;
    }

    public static BigInteger generateNamespaceId(String namespaceName) {
        List<BigInteger> namespacePath = IdGenerator.generateNamespacePath(namespaceName);
        return namespacePath.get(namespacePath.size() - 1);
    }

    public static BigInteger generateSubNamespaceIdFromParentId(BigInteger parentId, String namespaceName) {
        return IdGenerator.generateId(namespaceName, parentId);
    }

    public static BigInteger generateMosaicId(String namespaceName, String mosaicName) {
        if (mosaicName.length() == 0) {
            throw new IllegalIdentifierException("having zero length");
        }
        List<BigInteger> namespacePath = IdGenerator.generateNamespacePath(namespaceName);
        BigInteger namespaceId = namespacePath.get(namespacePath.size() - 1);
        if (!mosaicName.matches("^[a-z0-9][a-z0-9-_]*$")) {
            throw new IllegalIdentifierException("invalid mosaic name");
        }
        return IdGenerator.generateId(mosaicName, namespaceId);
    }
}

