/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;

public class Deadline {
    public static Instant TIMESTAMP_NEMSIS_BLOCK = Instant.ofEpochSecond(1459468800L);
    private final Instant instant;

    public Deadline(int units, ChronoUnit chronoUnit) {
        this.instant = Instant.now().plus((long)units, chronoUnit);
    }

    public Deadline(BigInteger input) {
        this.instant = Instant.ofEpochMilli(input.longValue());
    }

    public static Deadline create(int units, ChronoUnit chronoUnit) {
        return new Deadline(units, chronoUnit);
    }

    public long getInstant() {
        return this.instant.toEpochMilli() - TIMESTAMP_NEMSIS_BLOCK.toEpochMilli();
    }

    public LocalDateTime getLocalDateTime(ZoneId zoneId) {
        return LocalDateTime.ofInstant(this.instant, zoneId);
    }

    public LocalDateTime getLocalDateTime() {
        return this.getLocalDateTime(ZoneId.systemDefault());
    }
}

