/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import io.nem.core.crypto.Signer;
import io.nem.sdk.model.account.Account;
import io.nem.sdk.model.transaction.AggregateTransaction;
import io.nem.sdk.model.transaction.CosignatureSignedTransaction;
import org.bouncycastle.util.encoders.Hex;

public class CosignatureTransaction {
    private final AggregateTransaction transactionToCosign;

    public CosignatureTransaction(AggregateTransaction transactionToCosign) {
        if (!transactionToCosign.getTransactionInfo().isPresent() || !transactionToCosign.getTransactionInfo().get().getHash().isPresent()) {
            throw new IllegalArgumentException("Transaction to cosign should be announced before being able to cosign it");
        }
        this.transactionToCosign = transactionToCosign;
    }

    public static CosignatureTransaction create(AggregateTransaction transactionToCosign) {
        return new CosignatureTransaction(transactionToCosign);
    }

    public AggregateTransaction getTransactionToCosign() {
        return this.transactionToCosign;
    }

    public CosignatureSignedTransaction signWith(Account account) {
        Signer signer = new Signer(account.getKeyPair());
        byte[] bytes = Hex.decode((String)this.transactionToCosign.getTransactionInfo().get().getHash().get());
        byte[] signatureBytes = signer.sign(bytes).getBytes();
        return new CosignatureSignedTransaction(this.transactionToCosign.getTransactionInfo().get().getHash().get(), Hex.toHexString((byte[])signatureBytes), account.getPublicKey());
    }
}

