/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import com.google.flatbuffers.FlatBufferBuilder;
import io.nem.core.crypto.Signer;
import io.nem.sdk.model.account.Account;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.AggregateTransactionBuffer;
import io.nem.sdk.model.transaction.AggregateTransactionCosignature;
import io.nem.sdk.model.transaction.AggregateTransactionSchema;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.Schema;
import io.nem.sdk.model.transaction.SignedTransaction;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.model.transaction.UInt64;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.bouncycastle.util.encoders.Hex;

public class AggregateTransaction
extends Transaction {
    private final List<Transaction> innerTransactions;
    private final List<AggregateTransactionCosignature> cosignatures;
    private final Schema schema = new AggregateTransactionSchema();

    public AggregateTransaction(NetworkType networkType, TransactionType transactionType, Integer version, Deadline deadline, BigInteger fee, List<Transaction> innerTransactions, List<AggregateTransactionCosignature> cosignatures, String signature, PublicAccount signer, TransactionInfo transactionInfo) {
        this(networkType, transactionType, version, deadline, fee, innerTransactions, cosignatures, Optional.of(signature), Optional.of(signer), Optional.of(transactionInfo));
    }

    public AggregateTransaction(NetworkType networkType, TransactionType transactionType, Integer version, Deadline deadline, BigInteger fee, List<Transaction> innerTransactions, List<AggregateTransactionCosignature> cosignatures) {
        this(networkType, transactionType, version, deadline, fee, innerTransactions, cosignatures, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private AggregateTransaction(NetworkType networkType, TransactionType transactionType, Integer version, Deadline deadline, BigInteger fee, List<Transaction> innerTransactions, List<AggregateTransactionCosignature> cosignatures, Optional<String> signature, Optional<PublicAccount> signer, Optional<TransactionInfo> transactionInfo) {
        super(transactionType, networkType, version, deadline, fee, signature, signer, transactionInfo);
        Validate.notNull(innerTransactions, (String)"InnerTransactions must not be null");
        Validate.notNull(cosignatures, (String)"Cosignatures must not be null");
        this.innerTransactions = innerTransactions;
        this.cosignatures = cosignatures;
    }

    public static AggregateTransaction createComplete(Deadline deadline, List<Transaction> innerTransactions, NetworkType networkType) {
        return new AggregateTransaction(networkType, TransactionType.AGGREGATE_COMPLETE, 2, deadline, BigInteger.valueOf(0L), innerTransactions, new ArrayList<AggregateTransactionCosignature>());
    }

    public static AggregateTransaction createBonded(Deadline deadline, List<Transaction> innerTransactions, NetworkType networkType) {
        return new AggregateTransaction(networkType, TransactionType.AGGREGATE_BONDED, 2, deadline, BigInteger.valueOf(0L), innerTransactions, new ArrayList<AggregateTransactionCosignature>());
    }

    public List<Transaction> getInnerTransactions() {
        return this.innerTransactions;
    }

    public List<AggregateTransactionCosignature> getCosignatures() {
        return this.cosignatures;
    }

    @Override
    byte[] generateBytes() {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        BigInteger deadlineBigInt = BigInteger.valueOf(this.getDeadline().getInstant());
        int[] fee = new int[]{0, 0};
        int version = (int)Long.parseLong(Integer.toHexString(this.getNetworkType().getValue()) + "0" + Integer.toHexString(this.getVersion()), 16);
        byte[] transactionsBytes = new byte[]{};
        for (Transaction innerTransaction : this.innerTransactions) {
            byte[] transactionBytes = innerTransaction.toAggregateTransactionBytes();
            transactionsBytes = ArrayUtils.addAll((byte[])transactionsBytes, (byte[])transactionBytes);
        }
        int signatureVector = AggregateTransactionBuffer.createSignatureVector(builder, new byte[64]);
        int signerVector = AggregateTransactionBuffer.createSignerVector(builder, new byte[32]);
        int deadlineVector = AggregateTransactionBuffer.createDeadlineVector(builder, UInt64.fromBigInteger(deadlineBigInt));
        int feeVector = AggregateTransactionBuffer.createFeeVector(builder, fee);
        int transactionsVector = AggregateTransactionBuffer.createTransactionsVector(builder, transactionsBytes);
        AggregateTransactionBuffer.startAggregateTransactionBuffer(builder);
        AggregateTransactionBuffer.addSize(builder, 124 + transactionsBytes.length);
        AggregateTransactionBuffer.addSignature(builder, signatureVector);
        AggregateTransactionBuffer.addSigner(builder, signerVector);
        AggregateTransactionBuffer.addVersion(builder, version);
        AggregateTransactionBuffer.addType(builder, this.getType().getValue());
        AggregateTransactionBuffer.addFee(builder, feeVector);
        AggregateTransactionBuffer.addDeadline(builder, deadlineVector);
        AggregateTransactionBuffer.addTransactionsSize(builder, transactionsBytes.length);
        AggregateTransactionBuffer.addTransactions(builder, transactionsVector);
        int codedTransaction = AggregateTransactionBuffer.endAggregateTransactionBuffer(builder);
        builder.finish(codedTransaction);
        return this.schema.serialize(builder.sizedByteArray());
    }

    public SignedTransaction signTransactionWithCosigners(Account initiatorAccount, List<Account> cosignatories) {
        SignedTransaction signedTransaction = this.signWith(initiatorAccount);
        String payload = signedTransaction.getPayload();
        for (Account cosignatory : cosignatories) {
            Signer signer = new Signer(cosignatory.getKeyPair());
            byte[] bytes = Hex.decode((String)signedTransaction.getHash());
            byte[] signatureBytes = signer.sign(bytes).getBytes();
            payload = payload + cosignatory.getPublicKey() + Hex.toHexString((byte[])signatureBytes);
        }
        byte[] payloadBytes = Hex.decode((String)payload);
        byte[] size = BigInteger.valueOf(payloadBytes.length).toByteArray();
        ArrayUtils.reverse((byte[])size);
        System.arraycopy(size, 0, payloadBytes, 0, size.length);
        return new SignedTransaction(Hex.toHexString((byte[])payloadBytes), signedTransaction.getHash(), this.getType());
    }

    public boolean signedByAccount(PublicAccount publicAccount) {
        return this.getSigner().get().equals(publicAccount) || this.getCosignatures().stream().anyMatch(o -> o.getSigner().equals(publicAccount));
    }
}

