/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.mosaic;

import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.mosaic.MosaicProperties;
import io.nem.sdk.model.namespace.NamespaceId;
import java.math.BigInteger;

public class MosaicInfo {
    private final boolean active;
    private final Integer index;
    private final String metaId;
    private final NamespaceId namespaceId;
    private final MosaicId mosaicId;
    private final BigInteger supply;
    private final BigInteger height;
    private final PublicAccount owner;
    private final MosaicProperties properties;

    public MosaicInfo(boolean active, Integer index, String metaId, NamespaceId namespaceId, MosaicId mosaicId, BigInteger supply, BigInteger height, PublicAccount owner, MosaicProperties properties) {
        this.active = active;
        this.index = index;
        this.metaId = metaId;
        this.namespaceId = namespaceId;
        this.mosaicId = mosaicId;
        this.supply = supply;
        this.height = height;
        this.owner = owner;
        this.properties = properties;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isExpired() {
        return !this.active;
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getMetaId() {
        return this.metaId;
    }

    public NamespaceId getNamespaceId() {
        return this.namespaceId;
    }

    public MosaicId getMosaicId() {
        return this.mosaicId;
    }

    public BigInteger getSupply() {
        return this.supply;
    }

    public BigInteger getHeight() {
        return this.height;
    }

    public PublicAccount getOwner() {
        return this.owner;
    }

    public boolean isSupplyMutable() {
        return this.properties.isSupplyMutable();
    }

    public boolean isTransferable() {
        return this.properties.isTransferable();
    }

    public boolean isLevyMutable() {
        return this.properties.isLevyMutable();
    }

    public BigInteger getDuration() {
        return this.properties.getDuration();
    }

    public int getDivisibility() {
        return this.properties.getDivisibility();
    }
}

