/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.blockchain;

public enum NetworkType {
    MAIN_NET(104),
    TEST_NET(152),
    MIJIN(96),
    MIJIN_TEST(144);

    private final int value;

    private NetworkType(int value) {
        this.value = value;
    }

    public static NetworkType rawValueOf(int value) {
        switch (value) {
            case 104: {
                return MAIN_NET;
            }
            case 152: {
                return TEST_NET;
            }
            case 96: {
                return MIJIN;
            }
            case 144: {
                return MIJIN_TEST;
            }
        }
        throw new IllegalArgumentException(value + " is not a valid value");
    }

    public int getValue() {
        return this.value;
    }
}

