/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.account;

import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.blockchain.NetworkType;
import java.util.Objects;

public class PublicAccount {
    private final Address address;
    private final String publicKey;

    public PublicAccount(String publicKey, NetworkType networkType) {
        this.address = Address.createFromPublicKey(publicKey, networkType);
        this.publicKey = publicKey;
    }

    public static PublicAccount createFromPublicKey(String publicKey, NetworkType networkType) {
        return new PublicAccount(publicKey, networkType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicAccount)) {
            return false;
        }
        PublicAccount that = (PublicAccount)o;
        return Objects.equals(this.address, that.address) && Objects.equals(this.publicKey, that.publicKey);
    }

    public Address getAddress() {
        return this.address;
    }

    public String getPublicKey() {
        return this.publicKey;
    }
}

