/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.account;

import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.mosaic.Mosaic;
import java.math.BigInteger;
import java.util.List;

public class AccountInfo {
    private final Address address;
    private final BigInteger addressHeight;
    private final String publicKey;
    private final BigInteger publicKeyHeight;
    private final BigInteger importance;
    private final BigInteger importanceHeight;
    private final List<Mosaic> mosaics;

    public AccountInfo(Address address, BigInteger addressHeight, String publicKey, BigInteger publicKeyHeight, BigInteger importance, BigInteger importanceHeight, List<Mosaic> mosaics) {
        this.address = address;
        this.addressHeight = addressHeight;
        this.publicKey = publicKey;
        this.publicKeyHeight = publicKeyHeight;
        this.importance = importance;
        this.importanceHeight = importanceHeight;
        this.mosaics = mosaics;
    }

    public Address getAddress() {
        return this.address;
    }

    public BigInteger getAddressHeight() {
        return this.addressHeight;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public BigInteger getPublicKeyHeight() {
        return this.publicKeyHeight;
    }

    public BigInteger getImportance() {
        return this.importance;
    }

    public BigInteger getImportanceHeight() {
        return this.importanceHeight;
    }

    public List<Mosaic> getMosaics() {
        return this.mosaics;
    }

    public PublicAccount getPublicAccount() {
        return PublicAccount.createFromPublicKey(this.publicKey, this.address.getNetworkType());
    }
}

