/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.account;

import io.nem.core.crypto.KeyPair;
import io.nem.core.crypto.PrivateKey;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.AggregateTransaction;
import io.nem.sdk.model.transaction.CosignatureSignedTransaction;
import io.nem.sdk.model.transaction.CosignatureTransaction;
import io.nem.sdk.model.transaction.SignedTransaction;
import io.nem.sdk.model.transaction.Transaction;
import java.util.List;
import javax.validation.constraints.NotNull;

public class Account {
    private final KeyPair keyPair;
    private final PublicAccount publicAccount;

    public Account(@NotNull String privateKey, NetworkType networkType) {
        this.keyPair = new KeyPair(PrivateKey.fromHexString(privateKey));
        this.publicAccount = new PublicAccount(this.getPublicKey(), networkType);
    }

    public Account(KeyPair keyPair, NetworkType networkType) {
        this.keyPair = keyPair;
        this.publicAccount = new PublicAccount(this.getPublicKey(), networkType);
    }

    public static Account createFromPrivateKey(String privateKey, NetworkType networkType) {
        return new Account(privateKey, networkType);
    }

    public String getPublicKey() {
        return this.keyPair.getPublicKey().toString().toUpperCase();
    }

    public String getPrivateKey() {
        return this.keyPair.getPrivateKey().toString().toUpperCase();
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public Address getAddress() {
        return this.publicAccount.getAddress();
    }

    public PublicAccount getPublicAccount() {
        return this.publicAccount;
    }

    public SignedTransaction sign(Transaction transaction) {
        return transaction.signWith(this);
    }

    public CosignatureSignedTransaction signCosignatureTransaction(CosignatureTransaction cosignatureTransaction) {
        return cosignatureTransaction.signWith(this);
    }

    public SignedTransaction signTransactionWithCosignatories(AggregateTransaction transaction, List<Account> cosignatories) {
        return transaction.signTransactionWithCosigners(this, cosignatories);
    }
}

