/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure;

import io.nem.sdk.infrastructure.TransactionMapping;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.mosaic.Mosaic;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.Message;
import io.nem.sdk.model.transaction.PlainMessage;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.nem.sdk.model.transaction.TransferTransaction;
import io.vertx.core.json.JsonObject;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.bouncycastle.util.encoders.Hex;

class TransferTransactionMapping
extends TransactionMapping {
    TransferTransactionMapping() {
    }

    @Override
    public TransferTransaction apply(JsonObject input) {
        TransactionInfo transactionInfo = this.createTransactionInfo(input.getJsonObject("meta"));
        JsonObject transaction = input.getJsonObject("transaction");
        Deadline deadline = new Deadline(this.extractBigInteger(transaction.getJsonArray("deadline")));
        ArrayList<Mosaic> mosaics = new ArrayList();
        if (transaction.getJsonArray("mosaics") != null) {
            mosaics = transaction.getJsonArray("mosaics").stream().map(item -> (JsonObject)item).map(mosaic -> new Mosaic(new MosaicId(this.extractBigInteger(mosaic.getJsonArray("id"))), this.extractBigInteger(mosaic.getJsonArray("amount")))).collect(Collectors.toList());
        }
        PlainMessage message = PlainMessage.Empty;
        if (transaction.getJsonObject("message") != null) {
            try {
                message = new PlainMessage(new String(Hex.decode((String)transaction.getJsonObject("message").getString("payload")), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                message = new PlainMessage(transaction.getJsonObject("message").getString("payload"));
            }
        }
        return new TransferTransaction(this.extractNetworkType(transaction.getInteger("version")), this.extractTransactionVersion(transaction.getInteger("version")), deadline, this.extractBigInteger(transaction.getJsonArray("fee")), Address.createFromEncoded(transaction.getString("recipient")), mosaics, (Message)message, transaction.getString("signature"), new PublicAccount(transaction.getString("signer"), this.extractNetworkType(transaction.getInteger("version"))), transactionInfo);
    }
}

