/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure;

import io.nem.sdk.infrastructure.AggregateTransactionMapping;
import io.nem.sdk.infrastructure.LockFundsTransactionMapping;
import io.nem.sdk.infrastructure.MosaicCreationTransactionMapping;
import io.nem.sdk.infrastructure.MosaicSupplyChangeTransactionMapping;
import io.nem.sdk.infrastructure.MultisigModificationTransactionMapping;
import io.nem.sdk.infrastructure.NamespaceCreationTransactionMapping;
import io.nem.sdk.infrastructure.SecretLockTransactionMapping;
import io.nem.sdk.infrastructure.SecretProofTransactionMapping;
import io.nem.sdk.infrastructure.TransferTransactionMapping;
import io.nem.sdk.infrastructure.UInt64DTO;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.nem.sdk.model.transaction.TransactionType;
import io.reactivex.functions.Function;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.math.BigInteger;

public class TransactionMapping
implements Function<JsonObject, Transaction> {
    public Transaction apply(JsonObject input) {
        JsonObject transaction = input.getJsonObject("transaction");
        int type = transaction.getInteger("type");
        if (type == TransactionType.TRANSFER.getValue()) {
            return new TransferTransactionMapping().apply(input);
        }
        if (type == TransactionType.REGISTER_NAMESPACE.getValue()) {
            return new NamespaceCreationTransactionMapping().apply(input);
        }
        if (type == TransactionType.MOSAIC_DEFINITION.getValue()) {
            return new MosaicCreationTransactionMapping().apply(input);
        }
        if (type == TransactionType.MOSAIC_SUPPLY_CHANGE.getValue()) {
            return new MosaicSupplyChangeTransactionMapping().apply(input);
        }
        if (type == TransactionType.MODIFY_MULTISIG_ACCOUNT.getValue()) {
            return new MultisigModificationTransactionMapping().apply(input);
        }
        if (type == TransactionType.AGGREGATE_COMPLETE.getValue() || type == TransactionType.AGGREGATE_BONDED.getValue()) {
            return new AggregateTransactionMapping().apply(input);
        }
        if (type == TransactionType.LOCK.getValue()) {
            return new LockFundsTransactionMapping().apply(input);
        }
        if (type == TransactionType.SECRET_LOCK.getValue()) {
            return new SecretLockTransactionMapping().apply(input);
        }
        if (type == TransactionType.SECRET_PROOF.getValue()) {
            return new SecretProofTransactionMapping().apply(input);
        }
        throw new UnsupportedOperationException("Unimplemented Transaction type");
    }

    BigInteger extractBigInteger(JsonArray input) {
        UInt64DTO uInt64DTO = new UInt64DTO();
        input.stream().forEach(item -> uInt64DTO.add(new Long(item.toString())));
        return uInt64DTO.extractIntArray();
    }

    Integer extractTransactionVersion(int version) {
        return (int)Long.parseLong(Integer.toHexString(version).substring(2, 4), 16);
    }

    NetworkType extractNetworkType(int version) {
        int networkType = (int)Long.parseLong(Integer.toHexString(version).substring(0, 2), 16);
        return NetworkType.rawValueOf(networkType);
    }

    public TransactionInfo createTransactionInfo(JsonObject jsonObject) {
        if (jsonObject.containsKey("hash") && jsonObject.containsKey("id")) {
            return TransactionInfo.create(this.extractBigInteger(jsonObject.getJsonArray("height")), jsonObject.getInteger("index"), jsonObject.getString("id"), jsonObject.getString("hash"), jsonObject.getString("merkleComponentHash"));
        }
        if (jsonObject.containsKey("aggregateHash") && jsonObject.containsKey("id")) {
            return TransactionInfo.createAggregate(this.extractBigInteger(jsonObject.getJsonArray("height")), jsonObject.getInteger("index"), jsonObject.getString("id"), jsonObject.getString("aggregateHash"), jsonObject.getString("aggregateId"));
        }
        return TransactionInfo.create(this.extractBigInteger(jsonObject.getJsonArray("height")), jsonObject.getString("hash"), jsonObject.getString("merkleComponentHash"));
    }
}

