/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure;

import com.fasterxml.jackson.core.type.TypeReference;
import io.nem.sdk.infrastructure.Http;
import io.nem.sdk.infrastructure.NetworkHttp;
import io.nem.sdk.infrastructure.TransactionMapping;
import io.nem.sdk.infrastructure.TransactionRepository;
import io.nem.sdk.infrastructure.TransactionStatusDTO;
import io.nem.sdk.model.transaction.CosignatureSignedTransaction;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.SignedTransaction;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionAnnounceResponse;
import io.nem.sdk.model.transaction.TransactionStatus;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.ext.web.codec.BodyCodec;
import java.net.MalformedURLException;
import java.util.List;
import java.util.stream.Collectors;

public class TransactionHttp
extends Http
implements TransactionRepository {
    public TransactionHttp(String host) throws MalformedURLException {
        this(host + "/transaction/", new NetworkHttp(host));
    }

    public TransactionHttp(String host, NetworkHttp networkHttp) throws MalformedURLException {
        super(host, networkHttp);
    }

    @Override
    public Observable<Transaction> getTransaction(String transactionHash) {
        return this.client.getAbs(this.url + transactionHash).as(BodyCodec.jsonObject()).rxSend().toObservable().map(Http::mapJsonObjectOrError).map(json -> new JsonObject(json.toString())).map((Function)new TransactionMapping());
    }

    @Override
    public Observable<List<Transaction>> getTransactions(List<String> transactionHashes) {
        JsonObject requestBody = new JsonObject();
        requestBody.put("transactionIds", transactionHashes);
        return this.client.postAbs(this.url.toString()).as(BodyCodec.jsonArray()).rxSendJson((Object)requestBody).toObservable().map(Http::mapJsonArrayOrError).map(json -> new JsonArray(json.toString()).stream().map(s -> (JsonObject)s).collect(Collectors.toList())).flatMapIterable(item -> item).map((Function)new TransactionMapping()).toList().toObservable();
    }

    @Override
    public Observable<TransactionStatus> getTransactionStatus(String transactionHash) {
        return this.client.getAbs(this.url + transactionHash + "/status").as(BodyCodec.jsonObject()).rxSend().toObservable().map(Http::mapJsonObjectOrError).map(json -> (TransactionStatusDTO)this.objectMapper.readValue(json.toString(), TransactionStatusDTO.class)).map(transactionStatusDTO -> new TransactionStatus(transactionStatusDTO.getGroup(), transactionStatusDTO.getStatus(), transactionStatusDTO.getHash(), new Deadline(transactionStatusDTO.getDeadline().extractIntArray()), transactionStatusDTO.getHeight().extractIntArray()));
    }

    @Override
    public Observable<List<TransactionStatus>> getTransactionStatuses(List<String> transactionHashes) {
        JsonObject requestBody = new JsonObject();
        requestBody.put("hashes", transactionHashes);
        return this.client.postAbs(this.url + "/statuses").as(BodyCodec.jsonArray()).rxSendJson((Object)requestBody).toObservable().map(Http::mapJsonArrayOrError).map(json -> (List)this.objectMapper.readValue(json.toString(), (TypeReference)new TypeReference<List<TransactionStatusDTO>>(){})).flatMapIterable(item -> item).map(transactionStatusDTO -> new TransactionStatus(transactionStatusDTO.getGroup(), transactionStatusDTO.getStatus(), transactionStatusDTO.getHash(), new Deadline(transactionStatusDTO.getDeadline().extractIntArray()), transactionStatusDTO.getHeight().extractIntArray())).toList().toObservable();
    }

    @Override
    public Observable<TransactionAnnounceResponse> announce(SignedTransaction signedTransaction) {
        JsonObject requestBody = new JsonObject();
        requestBody.put("payload", signedTransaction.getPayload());
        return this.client.putAbs(this.url.toString()).as(BodyCodec.jsonObject()).rxSendJson((Object)requestBody).toObservable().map(Http::mapJsonObjectOrError).map(json -> new TransactionAnnounceResponse(new JsonObject(json.toString()).getString("message")));
    }

    @Override
    public Observable<TransactionAnnounceResponse> announceAggregateBonded(SignedTransaction signedTransaction) {
        JsonObject requestBody = new JsonObject();
        requestBody.put("payload", signedTransaction.getPayload());
        return this.client.putAbs(this.url + "/partial").as(BodyCodec.jsonObject()).rxSendJson((Object)requestBody).toObservable().map(Http::mapJsonObjectOrError).map(json -> new TransactionAnnounceResponse(new JsonObject(json.toString()).getString("message")));
    }

    @Override
    public Observable<TransactionAnnounceResponse> announceAggregateBondedCosignature(CosignatureSignedTransaction cosignatureSignedTransaction) {
        JsonObject requestBody = new JsonObject();
        requestBody.put("parentHash", cosignatureSignedTransaction.getParentHash());
        requestBody.put("signature", cosignatureSignedTransaction.getSignature());
        requestBody.put("signer", cosignatureSignedTransaction.getSigner());
        return this.client.putAbs(this.url + "/cosignature").as(BodyCodec.jsonObject()).rxSendJson((Object)requestBody).toObservable().map(Http::mapJsonObjectOrError).map(json -> new TransactionAnnounceResponse(new JsonObject(json.toString()).getString("message")));
    }
}

