/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure;

import io.nem.sdk.infrastructure.TransactionMapping;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.HashType;
import io.nem.sdk.model.transaction.SecretProofTransaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.vertx.core.json.JsonObject;

class SecretProofTransactionMapping
extends TransactionMapping {
    SecretProofTransactionMapping() {
    }

    @Override
    public SecretProofTransaction apply(JsonObject input) {
        TransactionInfo transactionInfo = this.createTransactionInfo(input.getJsonObject("meta"));
        JsonObject transaction = input.getJsonObject("transaction");
        Deadline deadline = new Deadline(this.extractBigInteger(transaction.getJsonArray("deadline")));
        NetworkType networkType = this.extractNetworkType(transaction.getInteger("version"));
        return new SecretProofTransaction(networkType, this.extractTransactionVersion(transaction.getInteger("version")), deadline, this.extractBigInteger(transaction.getJsonArray("fee")), HashType.rawValueOf(transaction.getInteger("hashAlgorithm")), transaction.getString("secret"), transaction.getString("proof"), transaction.getString("signature"), new PublicAccount(transaction.getString("signer"), networkType), transactionInfo);
    }
}

