/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure;

import io.nem.sdk.infrastructure.TransactionMapping;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.Mosaic;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.HashType;
import io.nem.sdk.model.transaction.SecretLockTransaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.vertx.core.json.JsonObject;

class SecretLockTransactionMapping
extends TransactionMapping {
    SecretLockTransactionMapping() {
    }

    @Override
    public SecretLockTransaction apply(JsonObject input) {
        TransactionInfo transactionInfo = this.createTransactionInfo(input.getJsonObject("meta"));
        JsonObject transaction = input.getJsonObject("transaction");
        Deadline deadline = new Deadline(this.extractBigInteger(transaction.getJsonArray("deadline")));
        NetworkType networkType = this.extractNetworkType(transaction.getInteger("version"));
        Mosaic mosaic = transaction.containsKey("mosaicId") ? new Mosaic(new MosaicId(this.extractBigInteger(transaction.getJsonArray("mosaicId"))), this.extractBigInteger(transaction.getJsonArray("amount"))) : new Mosaic(new MosaicId(this.extractBigInteger(transaction.getJsonObject("mosaic").getJsonArray("id"))), this.extractBigInteger(transaction.getJsonObject("mosaic").getJsonArray("amount")));
        return new SecretLockTransaction(networkType, this.extractTransactionVersion(transaction.getInteger("version")), deadline, this.extractBigInteger(transaction.getJsonArray("fee")), mosaic, this.extractBigInteger(transaction.getJsonArray("duration")), HashType.rawValueOf(transaction.getInteger("hashAlgorithm")), transaction.getString("secret"), Address.createFromEncoded(transaction.getString("recipient")), transaction.getString("signature"), new PublicAccount(transaction.getString("signer"), networkType), transactionInfo);
    }
}

